/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.configuration.StructuredOptionsSplitter;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class StructuredOptionsSplitterEscapeTest {
    @Parameter
    private TestSpec testSpec;

    StructuredOptionsSplitterEscapeTest() {
    }

    @Parameters(name="testSpec = {0}")
    private static Collection<TestSpec> getEncodeSpecs() {
        return Arrays.asList(TestSpec.encode("A,B,C,D", ";").expect("A,B,C,D"), TestSpec.encode("A;BCD", ";").expect("'A;BCD'"), TestSpec.encode("A'B'C'D", ";").expect("'A''B''C''D'"), TestSpec.encode("AB\"C\"D", ";").expect("'AB\"C\"D'"), TestSpec.encode("AB'\"D:B", ";").expect("'AB''\"D:B'"), TestSpec.encode("A,B,C,D", ",").expect("'A,B,C,D'"), TestSpec.encode("A;BCD", ",").expect("A;BCD"), TestSpec.encode("AB\"C\"D", ",").expect("'AB\"C\"D'"), TestSpec.encode("AB'\"D:B", ",").expect("'AB''\"D:B'"), TestSpec.encode("A;B;C;D", ",", ":").expect("A;B;C;D"), TestSpec.encode("A;B;C:D", ",", ":").expect("'A;B;C:D'"));
    }

    @TestTemplate
    void testEscapeWithSingleQuote() {
        String encoded = StructuredOptionsSplitter.escapeWithSingleQuote((String)this.testSpec.getString(), (String[])this.testSpec.getEscapeChars());
        Assertions.assertThat((String)encoded).isEqualTo(this.testSpec.getEncodedString());
    }

    private static class TestSpec {
        private final String string;
        private final String[] escapeChars;
        private String encodedString;

        private TestSpec(String string, String ... escapeChars) {
            this.string = string;
            this.escapeChars = escapeChars;
        }

        public static TestSpec encode(String string, String ... escapeChars) {
            return new TestSpec(string, escapeChars);
        }

        public TestSpec expect(String string) {
            this.encodedString = string;
            return this;
        }

        public String getString() {
            return this.string;
        }

        public String getEncodedString() {
            return this.encodedString;
        }

        public String[] getEscapeChars() {
            return this.escapeChars;
        }
    }
}

