/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.flink.core.fs.AutoCloseableRegistry;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

class AutoCloseableRegistryTest {
    AutoCloseableRegistryTest() {
    }

    @Test
    void testReverseOrderOfClosing() throws Exception {
        ArrayList closeOrder = new ArrayList();
        AutoCloseableRegistry autoCloseableRegistry = new AutoCloseableRegistry();
        autoCloseableRegistry.registerCloseable(() -> closeOrder.add(3));
        autoCloseableRegistry.registerCloseable(() -> closeOrder.add(2));
        autoCloseableRegistry.registerCloseable(() -> closeOrder.add(1));
        autoCloseableRegistry.close();
        int expected = 1;
        Iterator iterator = closeOrder.iterator();
        while (iterator.hasNext()) {
            int actual = (Integer)iterator.next();
            Assertions.assertThat((int)actual).isEqualTo(expected++);
        }
    }

    @Test
    void testSuppressedExceptions() throws Exception {
        AutoCloseableRegistry autoCloseableRegistry = new AutoCloseableRegistry();
        autoCloseableRegistry.registerCloseable(() -> {
            throw new AssertionError((Object)"3");
        });
        autoCloseableRegistry.registerCloseable(() -> {
            throw new Exception("2");
        });
        autoCloseableRegistry.registerCloseable(() -> {
            throw new Exception("1");
        });
        try {
            autoCloseableRegistry.close();
            Assertions.fail((String)"Close should throw exception");
        }
        catch (Exception ex) {
            Assertions.assertThatThrownBy(() -> {
                throw ex;
            }).hasMessage("1").satisfies(new ThrowingConsumer[]{e -> Assertions.assertThat((Throwable)e.getSuppressed()[0]).hasMessage("2"), e -> Assertions.assertThat((Throwable)e.getSuppressed()[1]).hasMessage("java.lang.AssertionError: 3")});
        }
    }
}

