/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileAlreadyExistsException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalDataOutputStream;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import sun.misc.Unsafe;

class InitOutputPathTest {
    @TempDir
    private static java.nio.file.Path tempFolder;

    InitOutputPathTest() {
    }

    @Test
    void testErrorOccursUnSynchronized() throws Exception {
        Field lockField = FileSystem.class.getDeclaredField("OUTPUT_DIRECTORY_INIT_LOCK");
        InitOutputPathTest.setStaticFieldUsingUnsafe(lockField, new NoOpLock());
        Assertions.assertThatThrownBy(() -> this.runTest(true)).isInstanceOf(FileNotFoundException.class);
        InitOutputPathTest.setStaticFieldUsingUnsafe(lockField, new ReentrantLock(true));
    }

    @Test
    void testProperSynchronized() throws Exception {
        this.runTest(false);
    }

    private static void setStaticFieldUsingUnsafe(final Field field, final Object newValue) {
        try {
            boolean isFinalModifierPresent;
            field.setAccessible(true);
            int fieldModifiersMask = field.getModifiers();
            boolean bl = isFinalModifierPresent = (fieldModifiersMask & 0x10) == 16;
            if (isFinalModifierPresent) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Unsafe unsafe = InitOutputPathTest.getUnsafe();
                            long offset = unsafe.staticFieldOffset(field);
                            Object base = unsafe.staticFieldBase(field);
                            InitOutputPathTest.setFieldUsingUnsafe(base, field.getType(), offset, newValue, unsafe);
                            return null;
                        }
                        catch (Throwable t) {
                            throw new RuntimeException(t);
                        }
                    }
                });
            } else {
                field.set(null, newValue);
            }
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Unsafe getUnsafe() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        Field field1 = Unsafe.class.getDeclaredField("theUnsafe");
        field1.setAccessible(true);
        Unsafe unsafe = (Unsafe)field1.get(null);
        return unsafe;
    }

    private static void setFieldUsingUnsafe(Object base, Class type, long offset, Object newValue, Unsafe unsafe) {
        if (type == Integer.TYPE) {
            unsafe.putInt(base, offset, (Integer)newValue);
        } else if (type == Short.TYPE) {
            unsafe.putShort(base, offset, (Short)newValue);
        } else if (type == Long.TYPE) {
            unsafe.putLong(base, offset, (Long)newValue);
        } else if (type == Byte.TYPE) {
            unsafe.putByte(base, offset, (Byte)newValue);
        } else if (type == Boolean.TYPE) {
            unsafe.putBoolean(base, offset, (Boolean)newValue);
        } else if (type == Float.TYPE) {
            unsafe.putFloat(base, offset, ((Float)newValue).floatValue());
        } else if (type == Double.TYPE) {
            unsafe.putDouble(base, offset, (Double)newValue);
        } else if (type == Character.TYPE) {
            unsafe.putChar(base, offset, ((Character)newValue).charValue());
        } else {
            unsafe.putObject(base, offset, newValue);
        }
    }

    private void runTest(boolean useAwaits) throws Exception {
        File tempFile = TempDirUtils.newFile((java.nio.file.Path)tempFolder);
        Path path1 = new Path(tempFile.getAbsolutePath(), "1");
        Path path2 = new Path(tempFile.getAbsolutePath(), "2");
        OneShotLatch deleteAwaitLatch1 = new OneShotLatch();
        OneShotLatch deleteAwaitLatch2 = new OneShotLatch();
        OneShotLatch mkdirsAwaitLatch1 = new OneShotLatch();
        OneShotLatch mkdirsAwaitLatch2 = new OneShotLatch();
        OneShotLatch deleteTriggerLatch1 = new OneShotLatch();
        OneShotLatch deletetriggerLatch2 = new OneShotLatch();
        OneShotLatch mkdirsTriggerLatch1 = new OneShotLatch();
        OneShotLatch mkdirsTriggerLatch2 = new OneShotLatch();
        OneShotLatch createAwaitLatch = new OneShotLatch();
        OneShotLatch createTriggerLatch = new OneShotLatch();
        SyncedFileSystem fs1 = new SyncedFileSystem(deleteAwaitLatch1, mkdirsAwaitLatch1, deleteTriggerLatch1, mkdirsTriggerLatch1, createAwaitLatch, createTriggerLatch);
        SyncedFileSystem fs2 = new SyncedFileSystem(deleteAwaitLatch2, mkdirsAwaitLatch2, deletetriggerLatch2, mkdirsTriggerLatch2, createAwaitLatch, createTriggerLatch);
        FileCreator thread1 = new FileCreator((FileSystem)fs1, path1);
        FileCreator thread2 = new FileCreator((FileSystem)fs2, path2);
        thread1.start();
        thread2.start();
        if (useAwaits) {
            deleteAwaitLatch1.await();
            deleteAwaitLatch2.await();
        } else {
            Thread.sleep(5L);
        }
        mkdirsTriggerLatch1.trigger();
        deleteTriggerLatch1.trigger();
        if (useAwaits) {
            createAwaitLatch.await();
        } else {
            Thread.sleep(100L);
        }
        deletetriggerLatch2.trigger();
        if (useAwaits) {
            mkdirsAwaitLatch2.await();
        } else {
            Thread.sleep(5L);
        }
        createTriggerLatch.trigger();
        if (useAwaits) {
            thread1.sync();
        } else {
            Thread.sleep(5L);
        }
        mkdirsTriggerLatch2.trigger();
        thread1.sync();
        thread2.sync();
    }

    private static final class NoOpLock
    extends ReentrantLock {
        private NoOpLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() {
        }

        @Override
        public void unlock() {
        }
    }

    private static class SyncedFileSystem
    extends LocalFileSystem {
        private final OneShotLatch deleteTriggerLatch;
        private final OneShotLatch mkdirsTriggerLatch;
        private final OneShotLatch deleteAwaitLatch;
        private final OneShotLatch mkdirsAwaitLatch;
        private final OneShotLatch createAwaitLatch;
        private final OneShotLatch createTriggerLatch;

        SyncedFileSystem(OneShotLatch deleteTriggerLatch, OneShotLatch mkdirsTriggerLatch, OneShotLatch deleteAwaitLatch, OneShotLatch mkdirsAwaitLatch, OneShotLatch createAwaitLatch, OneShotLatch createTriggerLatch) {
            this.deleteTriggerLatch = deleteTriggerLatch;
            this.mkdirsTriggerLatch = mkdirsTriggerLatch;
            this.deleteAwaitLatch = deleteAwaitLatch;
            this.mkdirsAwaitLatch = mkdirsAwaitLatch;
            this.createAwaitLatch = createAwaitLatch;
            this.createTriggerLatch = createTriggerLatch;
        }

        public FSDataOutputStream create(Path filePath, FileSystem.WriteMode overwrite) throws IOException {
            Preconditions.checkNotNull((Object)filePath, (String)"filePath");
            if (this.exists(filePath) && overwrite == FileSystem.WriteMode.NO_OVERWRITE) {
                throw new FileAlreadyExistsException("File already exists: " + filePath);
            }
            Path parent = filePath.getParent();
            if (parent != null && !this.mkdirs(parent)) {
                throw new IOException("Mkdirs failed to create " + parent);
            }
            File file = this.pathToFile(filePath);
            this.createAwaitLatch.trigger();
            this.createTriggerLatch.await();
            return new LocalDataOutputStream(file);
        }

        public boolean delete(Path f, boolean recursive) throws IOException {
            this.deleteTriggerLatch.trigger();
            try {
                this.deleteAwaitLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("interrupted");
            }
            return super.delete(f, recursive);
        }

        public boolean mkdirs(Path f) throws IOException {
            this.mkdirsTriggerLatch.trigger();
            try {
                this.mkdirsAwaitLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("interrupted");
            }
            return super.mkdirs(f);
        }
    }

    private static class FileCreator
    extends CheckedThread {
        private final FileSystem fs;
        private final Path path;

        FileCreator(FileSystem fs, Path path) {
            this.fs = fs;
            this.path = path;
        }

        public void go() throws Exception {
            this.fs.initOutPathLocalFS(this.path.getParent(), FileSystem.WriteMode.OVERWRITE, true);
            try (FSDataOutputStream out = this.fs.create(this.path, FileSystem.WriteMode.OVERWRITE);){
                out.write(11);
            }
        }
    }
}

