/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.net.URI;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.LimitedConnectionsFileSystem;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class LimitedConnectionsConfigurationTest {
    @TempDir
    public File tempDir;

    LimitedConnectionsConfigurationTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testConfiguration() throws Exception {
        String fsScheme = "test";
        FileSystem schemeFs = FileSystem.get((URI)URI.create("test:///a/b/c"));
        FileSystem localFs = FileSystem.get((URI)File.createTempFile("junit", null, this.tempDir).toURI());
        Assertions.assertThat((Object)schemeFs).isNotInstanceOf(LimitedConnectionsFileSystem.class);
        Assertions.assertThat((Object)localFs).isNotInstanceOf(LimitedConnectionsFileSystem.class);
        Configuration config = new Configuration();
        config.set(ConfigurationUtils.getIntConfigOption((String)"fs.test.limit.total"), (Object)42);
        config.set(ConfigurationUtils.getIntConfigOption((String)"fs.test.limit.input"), (Object)11);
        config.set(ConfigurationUtils.getIntConfigOption((String)"fs.test.limit.output"), (Object)40);
        config.set(ConfigurationUtils.getIntConfigOption((String)"fs.test.limit.timeout"), (Object)12345);
        config.set(ConfigurationUtils.getIntConfigOption((String)"fs.test.limit.stream-timeout"), (Object)98765);
        try {
            FileSystem.initialize((Configuration)config);
            schemeFs = FileSystem.get((URI)URI.create("test:///a/b/c"));
            localFs = FileSystem.get((URI)File.createTempFile("junit", null, this.tempDir).toURI());
            Assertions.assertThat((Object)schemeFs).isInstanceOf(LimitedConnectionsFileSystem.class);
            Assertions.assertThat((Object)localFs).isNotInstanceOf(LimitedConnectionsFileSystem.class);
            LimitedConnectionsFileSystem limitedFs = (LimitedConnectionsFileSystem)schemeFs;
            Assertions.assertThat((int)limitedFs.getMaxNumOpenStreamsTotal()).isEqualTo(42);
            Assertions.assertThat((int)limitedFs.getMaxNumOpenInputStreams()).isEqualTo(11);
            Assertions.assertThat((int)limitedFs.getMaxNumOpenOutputStreams()).isEqualTo(40);
            Assertions.assertThat((long)limitedFs.getStreamOpenTimeout()).isEqualTo(12345L);
            Assertions.assertThat((long)limitedFs.getStreamInactivityTimeout()).isEqualTo(98765L);
        }
        finally {
            FileSystem.initialize((Configuration)new Configuration());
        }
    }

    @Test
    void testConnectionLimitingSettings() {
        String scheme = "testscheme";
        Assertions.assertThat((Object)LimitedConnectionsFileSystem.ConnectionLimitingSettings.fromConfig((Configuration)new Configuration(), (String)"testscheme")).isNull();
        Configuration conf = new Configuration();
        conf.set(CoreOptions.fileSystemConnectionLimit((String)"testscheme"), (Object)10);
        LimitedConnectionsFileSystem.ConnectionLimitingSettings settings = LimitedConnectionsFileSystem.ConnectionLimitingSettings.fromConfig((Configuration)conf, (String)"testscheme");
        Assertions.assertThat((Object)settings).isNotNull();
        Assertions.assertThat((int)settings.limitTotal).isEqualTo(10);
        Assertions.assertThat((int)settings.limitInput).isZero();
        Assertions.assertThat((int)settings.limitOutput).isZero();
        conf = new Configuration();
        conf.set(CoreOptions.fileSystemConnectionLimitIn((String)"testscheme"), (Object)10);
        settings = LimitedConnectionsFileSystem.ConnectionLimitingSettings.fromConfig((Configuration)conf, (String)"testscheme");
        Assertions.assertThat((Object)settings).isNotNull();
        Assertions.assertThat((int)settings.limitTotal).isZero();
        Assertions.assertThat((int)settings.limitInput).isEqualTo(10);
        Assertions.assertThat((int)settings.limitOutput).isZero();
        conf = new Configuration();
        conf.set(CoreOptions.fileSystemConnectionLimitOut((String)"testscheme"), (Object)10);
        settings = LimitedConnectionsFileSystem.ConnectionLimitingSettings.fromConfig((Configuration)conf, (String)"testscheme");
        Assertions.assertThat((Object)settings).isNotNull();
        Assertions.assertThat((int)settings.limitTotal).isZero();
        Assertions.assertThat((int)settings.limitInput).isZero();
        Assertions.assertThat((int)settings.limitOutput).isEqualTo(10);
    }
}

