/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.flink.core.fs.RefCountedFile;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class RefCountedFileTest {
    @TempDir
    private static Path tempFolder;

    RefCountedFileTest() {
    }

    @Test
    void releaseToZeroRefCounterShouldDeleteTheFile() throws IOException {
        File newFile = TempDirUtils.newFile((Path)tempFolder, (String)(".tmp_" + UUID.randomUUID()));
        RefCountedFile fileUnderTest = new RefCountedFile(newFile);
        this.verifyTheFileIsStillThere();
        fileUnderTest.release();
        try (Stream<Path> files = Files.list(tempFolder);){
            Assertions.assertThat(files).isEmpty();
        }
    }

    @Test
    void retainsShouldRequirePlusOneReleasesToDeleteTheFile() throws IOException {
        File newFile = TempDirUtils.newFile((Path)tempFolder, (String)(".tmp_" + UUID.randomUUID()));
        RefCountedFile fileUnderTest = new RefCountedFile(newFile);
        this.verifyTheFileIsStillThere();
        fileUnderTest.retain();
        fileUnderTest.retain();
        Assertions.assertThat((int)fileUnderTest.getReferenceCounter()).isEqualTo(3);
        fileUnderTest.release();
        Assertions.assertThat((int)fileUnderTest.getReferenceCounter()).isEqualTo(2);
        this.verifyTheFileIsStillThere();
        fileUnderTest.release();
        Assertions.assertThat((int)fileUnderTest.getReferenceCounter()).isOne();
        this.verifyTheFileIsStillThere();
        fileUnderTest.release();
        try (Stream<Path> files = Files.list(tempFolder);){
            Assertions.assertThat(files).isEmpty();
        }
    }

    private void verifyTheFileIsStillThere() throws IOException {
        try (Stream<Path> files = Files.list(tempFolder);){
            Assertions.assertThat(files).hasSize(1);
        }
    }

    private static byte[] bytesOf(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }
}

