/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.core.io.VersionMismatchException;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class VersionedIOWriteableTest {
    VersionedIOWriteableTest() {
    }

    @Test
    void testReadSameVersion() throws Exception {
        byte[] serialized;
        String payload = "test";
        TestWriteable testWriteable = new TestWriteable(1, payload);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            testWriteable.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        testWriteable = new TestWriteable(1);
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            testWriteable.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        Assertions.assertThat((String)testWriteable.getData()).isEqualTo(payload);
    }

    @Test
    void testReadCompatibleVersion() throws Exception {
        byte[] serialized;
        String payload = "test";
        TestWriteable testWriteable = new TestWriteable(1, payload);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            testWriteable.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        testWriteable = new TestWriteable(2){

            public int[] getCompatibleVersions() {
                return new int[]{1, 2};
            }
        };
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            testWriteable.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        Assertions.assertThat((String)testWriteable.getData()).isEqualTo(payload);
    }

    @Test
    void testReadMismatchVersion() throws Exception {
        byte[] serialized;
        String payload = "test";
        TestWriteable testWriteable = new TestWriteable(1, payload);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            testWriteable.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        TestWriteable finalTestWriteable = new TestWriteable(2);
        Assertions.assertThatThrownBy(() -> {
            try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
                finalTestWriteable.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
            }
        }).isInstanceOf(VersionMismatchException.class);
        Assertions.assertThat((String)finalTestWriteable.getData()).isNull();
    }

    static class TestWriteable
    extends VersionedIOReadableWritable {
        private final int version;
        private String data;

        public TestWriteable(int version) {
            this(version, null);
        }

        public TestWriteable(int version, String data) {
            this.version = version;
            this.data = data;
        }

        public int getVersion() {
            return this.version;
        }

        public void write(DataOutputView out) throws IOException {
            super.write(out);
            out.writeUTF(this.data);
        }

        public void read(DataInputView in) throws IOException {
            super.read(in);
            this.data = in.readUTF();
        }

        public String getData() {
            return this.data;
        }
    }
}

