/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DataInputDeserializerTest {
    DataInputDeserializerTest() {
    }

    @Test
    void testAvailable() throws Exception {
        byte[] bytes = new byte[]{};
        DataInputDeserializer dis = new DataInputDeserializer(bytes, 0, bytes.length);
        Assertions.assertThat((int)dis.available()).isEqualTo(bytes.length);
        bytes = new byte[]{1, 2, 3};
        dis = new DataInputDeserializer(bytes, 0, bytes.length);
        Assertions.assertThat((int)dis.available()).isEqualTo(bytes.length);
        dis.readByte();
        Assertions.assertThat((int)dis.available()).isEqualTo(2);
        dis.readByte();
        Assertions.assertThat((int)dis.available()).isOne();
        dis.readByte();
        Assertions.assertThat((int)dis.available()).isZero();
        Assertions.assertThatThrownBy(() -> ((DataInputDeserializer)dis).readByte()).isInstanceOf(IOException.class);
        Assertions.assertThat((int)dis.available()).isZero();
    }

    @Test
    void testReadWithLenZero() throws IOException {
        byte[] bytes = new byte[]{};
        DataInputDeserializer dis = new DataInputDeserializer(bytes, 0, bytes.length);
        Assertions.assertThat((int)dis.available()).isZero();
        byte[] bytesForRead = new byte[]{};
        Assertions.assertThat((int)dis.read(bytesForRead, 0, 0)).isZero();
    }
}

