/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentTestBase;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class OffHeapUnsafeMemorySegmentTest
extends MemorySegmentTestBase {
    OffHeapUnsafeMemorySegmentTest(int pageSize) {
        super(pageSize);
    }

    @Override
    MemorySegment createSegment(int size) {
        return MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)size);
    }

    @Override
    MemorySegment createSegment(int size, Object owner) {
        return MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)size, (Object)owner, () -> {});
    }

    @Override
    @TestTemplate
    void testByteBufferWrapping(int pageSize) {
        Assertions.assertThatThrownBy(() -> this.createSegment(10).wrap(1, 2)).isInstanceOf(UnsupportedOperationException.class);
    }

    @TestTemplate
    void testCallCleanerOnFree() {
        CompletableFuture cleanerFuture = new CompletableFuture();
        MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)10, null, () -> cleanerFuture.complete(null)).free();
        Assertions.assertThat(cleanerFuture).isDone();
    }

    @TestTemplate
    void testCallCleanerOnceOnConcurrentFree() throws InterruptedException {
        AtomicInteger counter = new AtomicInteger(0);
        Runnable cleaner = () -> {
            try {
                counter.incrementAndGet();
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        };
        MemorySegment segment = MemorySegmentFactory.allocateOffHeapUnsafeMemory((int)10, null, (Runnable)cleaner);
        Thread t1 = new Thread(() -> ((MemorySegment)segment).free());
        Thread t2 = new Thread(() -> ((MemorySegment)segment).free());
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assertions.assertThat((AtomicInteger)counter).hasValue(1);
    }
}

