/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.serialization.types;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.testutils.serialization.types.SerializationTestType;

public class UnsignedShortType
implements SerializationTestType {
    private int value;

    public UnsignedShortType() {
        this.value = 0;
    }

    private UnsignedShortType(int value) {
        this.value = value;
    }

    @Override
    public UnsignedShortType getRandom(Random rnd) {
        return new UnsignedShortType(rnd.nextInt(32768) + 32768);
    }

    @Override
    public int length() {
        return 2;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeShort(this.value);
    }

    public void read(DataInputView in) throws IOException {
        this.value = in.readUnsignedShort();
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnsignedShortType) {
            UnsignedShortType other = (UnsignedShortType)obj;
            return this.value == other.value;
        }
        return false;
    }
}

