/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.types.parser.FloatParser;
import org.apache.flink.types.parser.ParserTestBase;

class FloatParserTest
extends ParserTestBase<Float> {
    FloatParserTest() {
    }

    @Override
    public String[] getValidTestValues() {
        return new String[]{"0", "0.0", "123.4", "0.124", ".623", "1234", "-12.34", String.valueOf(Float.MAX_VALUE), String.valueOf(Float.MIN_VALUE), String.valueOf(Float.NEGATIVE_INFINITY), String.valueOf(Float.POSITIVE_INFINITY), String.valueOf(Float.NaN), "1.234E2", "1.234e3", "1.234E-2", "1239"};
    }

    public Float[] getValidTestResults() {
        return new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(123.4f), Float.valueOf(0.124f), Float.valueOf(0.623f), Float.valueOf(1234.0f), Float.valueOf(-12.34f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NaN), Float.valueOf(123.4f), Float.valueOf(1234.0f), Float.valueOf(0.01234f), Float.valueOf(1239.0f)};
    }

    @Override
    public String[] getInvalidTestValues() {
        return new String[]{"a", "123abc4", "-57-6", "7-877678", " 1", "2 ", " ", "\t"};
    }

    @Override
    public boolean allowsEmptyField() {
        return false;
    }

    @Override
    public FieldParser<Float> getParser() {
        return new FloatParser();
    }

    @Override
    public Class<Float> getTypeClass() {
        return Float.class;
    }
}

