/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AbstractIDTest {
    AbstractIDTest() {
    }

    @Test
    void testSerialization() throws Exception {
        AbstractID origID = new AbstractID();
        AbstractID copyID = (AbstractID)CommonTestUtils.createCopySerializable((Serializable)origID);
        Assertions.assertThat((Comparable)copyID).hasSameHashCodeAs((Object)origID.hashCode());
        Assertions.assertThat((Comparable)copyID).isEqualTo((Object)origID);
    }

    @Test
    void testConvertToBytes() {
        AbstractID origID = new AbstractID();
        AbstractID copy1 = new AbstractID(origID);
        AbstractID copy2 = new AbstractID(origID.getBytes());
        AbstractID copy3 = new AbstractID(origID.getLowerPart(), origID.getUpperPart());
        Assertions.assertThat((Comparable)copy1).isEqualTo((Object)origID);
        Assertions.assertThat((Comparable)copy2).isEqualTo((Object)origID);
        Assertions.assertThat((Comparable)copy3).isEqualTo((Object)origID);
    }

    @Test
    void testCompare() throws Exception {
        AbstractID id1 = new AbstractID(0L, 0L);
        AbstractID id2 = new AbstractID(1L, 0L);
        AbstractID id3 = new AbstractID(0L, 1L);
        AbstractID id4 = new AbstractID(-1L, 0L);
        AbstractID id5 = new AbstractID(0L, -1L);
        AbstractID id6 = new AbstractID(-1L, -1L);
        AbstractID id7 = new AbstractID(Long.MAX_VALUE, Long.MAX_VALUE);
        AbstractID id8 = new AbstractID(Long.MIN_VALUE, Long.MIN_VALUE);
        AbstractID id9 = new AbstractID(Long.MAX_VALUE, Long.MIN_VALUE);
        AbstractID id10 = new AbstractID(Long.MIN_VALUE, Long.MAX_VALUE);
        Assertions.assertThat((Comparable)id1).isEqualByComparingTo((Comparable)((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id1)));
        Assertions.assertThat((Comparable)id2).isEqualByComparingTo((Comparable)((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id2)));
        Assertions.assertThat((Comparable)id3).isEqualByComparingTo((Comparable)((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id3)));
        Assertions.assertThat((Comparable)id4).isEqualByComparingTo((Comparable)((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id4)));
        Assertions.assertThat((Comparable)id5).isEqualByComparingTo((Comparable)((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id5)));
        Assertions.assertThat((Comparable)id6).isEqualByComparingTo((Comparable)((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id6)));
        Assertions.assertThat((Comparable)id7).isEqualByComparingTo((Comparable)((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id7)));
        Assertions.assertThat((Comparable)id8).isEqualByComparingTo((Comparable)((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id8)));
        Assertions.assertThat((Comparable)id9).isEqualByComparingTo((Comparable)((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id9)));
        Assertions.assertThat((Comparable)id10).isEqualByComparingTo((Comparable)((AbstractID)CommonTestUtils.createCopySerializable((Serializable)id10)));
        AbstractIDTest.assertCompare(id1, id2, -1);
        AbstractIDTest.assertCompare(id1, id3, -1);
        AbstractIDTest.assertCompare(id1, id4, 1);
        AbstractIDTest.assertCompare(id1, id5, 1);
        AbstractIDTest.assertCompare(id1, id6, 1);
        AbstractIDTest.assertCompare(id2, id5, 1);
        AbstractIDTest.assertCompare(id3, id5, 1);
        AbstractIDTest.assertCompare(id2, id6, 1);
        AbstractIDTest.assertCompare(id3, id6, 1);
        AbstractIDTest.assertCompare(id1, id7, -1);
        AbstractIDTest.assertCompare(id1, id8, 1);
        AbstractIDTest.assertCompare(id7, id8, 1);
        AbstractIDTest.assertCompare(id9, id10, -1);
        AbstractIDTest.assertCompare(id7, id9, 1);
        AbstractIDTest.assertCompare(id7, id10, 1);
        AbstractIDTest.assertCompare(id8, id9, -1);
        AbstractIDTest.assertCompare(id8, id10, -1);
    }

    @Test
    void testOldAbstractIDDeserialization() throws Exception {
        long lowerPart = 42L;
        long upperPart = 1337L;
        AbstractID expectedAbstractId = new AbstractID(42L, 1337L);
        String resourceName1 = "abstractID-with-toString-field";
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("abstractID-with-toString-field");){
            AbstractID deserializedAbstractId = (AbstractID)InstantiationUtil.deserializeObject((InputStream)resourceAsStream, (ClassLoader)this.getClass().getClassLoader());
            Assertions.assertThat((Comparable)deserializedAbstractId).isEqualTo((Object)expectedAbstractId);
        }
        String resourceName2 = "abstractID-with-toString-field-set";
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("abstractID-with-toString-field-set");){
            AbstractID deserializedAbstractId = (AbstractID)InstantiationUtil.deserializeObject((InputStream)resourceAsStream, (ClassLoader)this.getClass().getClassLoader());
            Assertions.assertThat((Comparable)deserializedAbstractId).isEqualTo((Object)expectedAbstractId);
        }
    }

    private static void assertCompare(AbstractID a, AbstractID b, int signum) {
        int sgnAB;
        int cmpAB = a.compareTo(b);
        int cmpBA = b.compareTo(a);
        int n = cmpAB > 0 ? 1 : (sgnAB = cmpAB < 0 ? -1 : 0);
        int sgnBA = cmpBA > 0 ? 1 : (cmpBA < 0 ? -1 : 0);
        Assertions.assertThat((int)sgnAB).isEqualTo(signum);
        Assertions.assertThat((int)(-sgnBA)).isEqualTo(sgnAB);
    }
}

