/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.util.MdcUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;
import org.slf4j.MDC;
import org.slf4j.helpers.BasicMDCAdapter;
import org.slf4j.spi.MDCAdapter;

@Isolated
public class MdcLogbackCompatibilityTest {
    private MDCAdapter originalAdapter;

    @BeforeEach
    void setUp() throws Exception {
        this.originalAdapter = this.getCurrentMDCAdapter();
        this.setMDCAdapter((MDCAdapter)new BasicMDCAdapter());
    }

    @AfterEach
    void tearDown() throws Exception {
        this.setMDCAdapter(this.originalAdapter);
    }

    @Test
    void testContextRestorationWorksWithNullContext() {
        Assertions.assertThat((Map)MDC.getCopyOfContextMap()).isNull();
        MdcUtils.MdcCloseable restoreContext = MdcUtils.withContext(Collections.singletonMap("k", "v"));
        Assertions.assertThat((String)MDC.get((String)"k")).isEqualTo("v");
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ((MdcUtils.MdcCloseable)restoreContext).close());
        Assertions.assertThat((String)MDC.get((String)"k")).isNull();
    }

    private MDCAdapter getCurrentMDCAdapter() throws Exception {
        Field adapterField = MDC.class.getDeclaredField("mdcAdapter");
        adapterField.setAccessible(true);
        return (MDCAdapter)adapterField.get(null);
    }

    private void setMDCAdapter(MDCAdapter adapter) throws Exception {
        Field adapterField = MDC.class.getDeclaredField("mdcAdapter");
        adapterField.setAccessible(true);
        adapterField.set(null, adapter);
    }
}

