/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.util.OutputTag;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OutputTagTest {
    OutputTagTest() {
    }

    @Test
    void testNullRejected() {
        Assertions.assertThatThrownBy(() -> new OutputTag(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testNullRejectedWithTypeInfo() {
        Assertions.assertThatThrownBy(() -> new OutputTag(null, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testEmptyStringRejected() {
        Assertions.assertThatThrownBy(() -> new OutputTag("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testEmptyStringRejectedWithTypeInfo() {
        Assertions.assertThatThrownBy(() -> new OutputTag("", (TypeInformation)BasicTypeInfo.INT_TYPE_INFO)).isInstanceOf(IllegalArgumentException.class);
    }
}

