/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.time.DayOfWeek;
import java.util.Random;
import org.apache.flink.util.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StringUtilsTest {
    StringUtilsTest() {
    }

    @Test
    void testControlCharacters() {
        String testString = "\b \t \n \f \r default";
        String controlString = StringUtils.showControlCharacters((String)testString);
        Assertions.assertThat((String)controlString).isEqualTo("\\b \\t \\n \\f \\r default");
    }

    @Test
    void testArrayAwareToString() {
        Assertions.assertThat((String)StringUtils.arrayAwareToString(null)).isEqualTo("null");
        Assertions.assertThat((String)StringUtils.arrayAwareToString((Object)DayOfWeek.MONDAY)).isEqualTo("MONDAY");
        Assertions.assertThat((String)StringUtils.arrayAwareToString((Object)new int[]{1, 2, 3})).isEqualTo("[1, 2, 3]");
        Assertions.assertThat((String)StringUtils.arrayAwareToString((Object)new byte[][]{{4, 5, 6}, null, new byte[0]})).isEqualTo("[[4, 5, 6], null, []]");
        Assertions.assertThat((String)StringUtils.arrayAwareToString((Object)new Object[]{new Integer[]{4, 5, 6}, null, DayOfWeek.MONDAY})).isEqualTo("[[4, 5, 6], null, MONDAY]");
    }

    @Test
    void testStringToHexArray() {
        String hex = "019f314a";
        byte[] hexArray = StringUtils.hexStringToByte((String)hex);
        byte[] expectedArray = new byte[]{1, -97, 49, 74};
        Assertions.assertThat((byte[])hexArray).isEqualTo((Object)expectedArray);
    }

    @Test
    void testHexArrayToString() {
        byte[] byteArray = new byte[]{1, -97, 49, 74};
        String hex = StringUtils.byteToHexString((byte[])byteArray);
        Assertions.assertThat((String)hex).isEqualTo("019f314a");
    }

    @Test
    void testGenerateAlphanumeric() {
        String str = StringUtils.generateRandomAlphanumericString((Random)new Random(), (int)256);
        Assertions.assertThat((String)str).matches((CharSequence)"[a-zA-Z0-9]{256}");
    }
}

