/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;

public class MissingTypeInfo
extends TypeInformation<InvalidTypesException> {
    private static final long serialVersionUID = -4212082837126702723L;
    private final String functionName;
    private final InvalidTypesException typeException;

    public MissingTypeInfo(String functionName) {
        this(functionName, new InvalidTypesException("An unknown error occurred."));
    }

    public MissingTypeInfo(String functionName, InvalidTypesException typeException) {
        this.functionName = functionName;
        this.typeException = typeException;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public InvalidTypesException getTypeException() {
        return this.typeException;
    }

    @Override
    public boolean isBasicType() {
        throw new UnsupportedOperationException("The missing type information cannot be used as a type information.");
    }

    @Override
    public boolean isTupleType() {
        throw new UnsupportedOperationException("The missing type information cannot be used as a type information.");
    }

    @Override
    public int getArity() {
        throw new UnsupportedOperationException("The missing type information cannot be used as a type information.");
    }

    @Override
    public Class<InvalidTypesException> getTypeClass() {
        throw new UnsupportedOperationException("The missing type information cannot be used as a type information.");
    }

    @Override
    public boolean isKeyType() {
        throw new UnsupportedOperationException("The missing type information cannot be used as a type information.");
    }

    @Override
    public TypeSerializer<InvalidTypesException> createSerializer(SerializerConfig serializerConfig) {
        throw new UnsupportedOperationException("The missing type information cannot be used as a type information.");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.functionName + ", " + this.typeException.getMessage() + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MissingTypeInfo) {
            MissingTypeInfo missingTypeInfo = (MissingTypeInfo)obj;
            return missingTypeInfo.canEqual(this) && this.functionName.equals(missingTypeInfo.functionName) && this.typeException.equals(missingTypeInfo.typeException);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * this.functionName.hashCode() + this.typeException.hashCode();
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof MissingTypeInfo;
    }

    @Override
    public int getTotalFields() {
        throw new UnsupportedOperationException("The missing type information cannot be used as a type information.");
    }
}

