/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.state;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;

@Internal
public class CompletedStateFuture<T>
implements InternalStateFuture<T> {
    T result;

    CompletedStateFuture(T result) {
        this.result = result;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public T get() {
        return this.result;
    }

    public <U> StateFuture<U> thenApply(FunctionWithException<? super T, ? extends U, ? extends Exception> fn) {
        return StateFutureUtils.completedFuture(FunctionWithException.unchecked(fn).apply(this.result));
    }

    public StateFuture<Void> thenAccept(ThrowingConsumer<? super T, ? extends Exception> action) {
        ThrowingConsumer.unchecked(action).accept(this.result);
        return StateFutureUtils.completedVoidFuture();
    }

    public <U> StateFuture<U> thenCompose(FunctionWithException<? super T, ? extends StateFuture<U>, ? extends Exception> action) {
        return (StateFuture)FunctionWithException.unchecked(action).apply(this.result);
    }

    public <U, V> StateFuture<V> thenCombine(StateFuture<? extends U> other, BiFunctionWithException<? super T, ? super U, ? extends V, ? extends Exception> fn) {
        return other.thenCompose(u -> {
            Object v = fn.apply(this.result, u);
            return StateFutureUtils.completedFuture(v);
        });
    }

    public <U, V> StateFuture<Tuple2<Boolean, Object>> thenConditionallyApply(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends U, ? extends Exception> actionIfTrue, FunctionWithException<? super T, ? extends V, ? extends Exception> actionIfFalse) {
        boolean test = (Boolean)FunctionWithException.unchecked(condition).apply(this.result);
        Object r = test ? FunctionWithException.unchecked(actionIfTrue).apply(this.result) : FunctionWithException.unchecked(actionIfFalse).apply(this.result);
        return StateFutureUtils.completedFuture(Tuple2.of((Object)test, r));
    }

    public <U> StateFuture<Tuple2<Boolean, U>> thenConditionallyApply(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends U, ? extends Exception> actionIfTrue) {
        boolean test = (Boolean)FunctionWithException.unchecked(condition).apply(this.result);
        Object r = test ? FunctionWithException.unchecked(actionIfTrue).apply(this.result) : null;
        return StateFutureUtils.completedFuture(Tuple2.of((Object)test, r));
    }

    public StateFuture<Boolean> thenConditionallyAccept(FunctionWithException<? super T, Boolean, ? extends Exception> condition, ThrowingConsumer<? super T, ? extends Exception> actionIfTrue, ThrowingConsumer<? super T, ? extends Exception> actionIfFalse) {
        boolean test = (Boolean)FunctionWithException.unchecked(condition).apply(this.result);
        if (test) {
            ThrowingConsumer.unchecked(actionIfTrue).accept(this.result);
        } else {
            ThrowingConsumer.unchecked(actionIfFalse).accept(this.result);
        }
        return StateFutureUtils.completedFuture(test);
    }

    public StateFuture<Boolean> thenConditionallyAccept(FunctionWithException<? super T, Boolean, ? extends Exception> condition, ThrowingConsumer<? super T, ? extends Exception> actionIfTrue) {
        boolean test = (Boolean)FunctionWithException.unchecked(condition).apply(this.result);
        if (test) {
            ThrowingConsumer.unchecked(actionIfTrue).accept(this.result);
        }
        return StateFutureUtils.completedFuture(test);
    }

    public <U, V> StateFuture<Tuple2<Boolean, Object>> thenConditionallyCompose(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends StateFuture<U>, ? extends Exception> actionIfTrue, FunctionWithException<? super T, ? extends StateFuture<V>, ? extends Exception> actionIfFalse) {
        boolean test = (Boolean)FunctionWithException.unchecked(condition).apply(this.result);
        StateFuture actionResult = test ? (StateFuture)FunctionWithException.unchecked(actionIfTrue).apply(this.result) : (StateFuture)FunctionWithException.unchecked(actionIfFalse).apply(this.result);
        return actionResult.thenApply(e -> Tuple2.of((Object)test, (Object)e));
    }

    public <U> StateFuture<Tuple2<Boolean, U>> thenConditionallyCompose(FunctionWithException<? super T, Boolean, ? extends Exception> condition, FunctionWithException<? super T, ? extends StateFuture<U>, ? extends Exception> actionIfTrue) {
        boolean test = (Boolean)FunctionWithException.unchecked(condition).apply(this.result);
        if (test) {
            StateFuture actionResult = (StateFuture)FunctionWithException.unchecked(actionIfTrue).apply(this.result);
            return actionResult.thenApply(e -> Tuple2.of((Object)true, (Object)e));
        }
        return StateFutureUtils.completedFuture(Tuple2.of((Object)false, null));
    }

    @Override
    public void complete(T result) {
        throw new UnsupportedOperationException("This state future has already been completed.");
    }

    @Override
    public void completeExceptionally(String message, Throwable ex) {
        throw new UnsupportedOperationException("This state future has already been completed.");
    }

    @Override
    public void thenSyncAccept(ThrowingConsumer<? super T, ? extends Exception> action) {
        ThrowingConsumer.unchecked(action).accept(this.result);
    }
}

