/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.io.Serializable;
import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.RecordTimestampAssigner;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.TimestampAssigner;
import org.apache.flink.api.common.eventtime.TimestampAssignerSupplier;
import org.apache.flink.api.common.eventtime.WatermarkAlignmentParams;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.eventtime.WatermarksWithIdleness;
import org.apache.flink.api.common.eventtime.WatermarksWithWatermarkAlignment;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.util.clock.RelativeClock;
import org.apache.flink.util.clock.SystemClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class WatermarkStrategyTest {
    @Test
    void testDefaultTimeStampAssigner() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps();
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        Assertions.assertThat((Object)wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext())).isInstanceOf(RecordTimestampAssigner.class);
    }

    @Test
    void testLambdaTimestampAssigner() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(event, timestamp) -> 42L);
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        TimestampAssigner timestampAssigner = wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext());
        Assertions.assertThat((long)timestampAssigner.extractTimestamp(null, 13L)).isEqualTo(42L);
    }

    @Test
    void testLambdaTimestampAssignerSupplier() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner(TimestampAssignerSupplier.of((SerializableTimestampAssigner & Serializable)(event, timestamp) -> 42L));
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        TimestampAssigner timestampAssigner = wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext());
        Assertions.assertThat((long)timestampAssigner.extractTimestamp(null, 13L)).isEqualTo(42L);
    }

    @Test
    void testAnonymousInnerTimestampAssigner() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((SerializableTimestampAssigner & Serializable)(element, recordTimestamp) -> 42L);
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        TimestampAssigner timestampAssigner = wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext());
        Assertions.assertThat((long)timestampAssigner.extractTimestamp(null, 13L)).isEqualTo(42L);
    }

    @Test
    void testClassTimestampAssigner() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((TimestampAssignerSupplier & Serializable)ctx -> new TestTimestampAssigner());
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        TimestampAssigner timestampAssigner = wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext());
        Assertions.assertThat((long)timestampAssigner.extractTimestamp(null, 13L)).isEqualTo(42L);
    }

    @Test
    void testClassTimestampAssignerUsingSupplier() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps().withTimestampAssigner((TimestampAssignerSupplier & Serializable)context -> new TestTimestampAssigner());
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        TimestampAssigner timestampAssigner = wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext());
        Assertions.assertThat((long)timestampAssigner.extractTimestamp(null, 13L)).isEqualTo(42L);
    }

    @Test
    void testWithIdlenessHelper() {
        WatermarkStrategy wmStrategy = WatermarkStrategy.forMonotonousTimestamps().withIdleness(Duration.ofDays(7L));
        ClosureCleaner.clean((Object)wmStrategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        Assertions.assertThat((Object)wmStrategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext())).isInstanceOf(RecordTimestampAssigner.class);
        Assertions.assertThat((Object)wmStrategy.createWatermarkGenerator(WatermarkStrategyTest.generatorContext())).isInstanceOf(WatermarksWithIdleness.class);
    }

    @Test
    void testWithWatermarkAlignment() {
        String watermarkGroup = "group-1";
        Duration maxAllowedWatermarkDrift = Duration.ofMillis(200L);
        WatermarkStrategy strategy = WatermarkStrategy.forMonotonousTimestamps().withWatermarkAlignment("group-1", maxAllowedWatermarkDrift).withIdleness(Duration.ofMillis(200L));
        ClosureCleaner.clean((Object)strategy, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        WatermarkAlignmentParams alignmentParameters = strategy.getAlignmentParameters();
        Assertions.assertThat((String)alignmentParameters.getWatermarkGroup()).isEqualTo("group-1");
        Assertions.assertThat((long)alignmentParameters.getMaxAllowedWatermarkDrift()).isEqualTo(maxAllowedWatermarkDrift.toMillis());
        Assertions.assertThat((long)alignmentParameters.getUpdateInterval()).isEqualTo(WatermarksWithWatermarkAlignment.DEFAULT_UPDATE_INTERVAL.toMillis());
        Assertions.assertThat((Object)strategy.createTimestampAssigner(WatermarkStrategyTest.assignerContext())).isInstanceOf(RecordTimestampAssigner.class);
        Assertions.assertThat((Object)strategy.createWatermarkGenerator(WatermarkStrategyTest.generatorContext())).isInstanceOf(WatermarksWithIdleness.class);
    }

    static TimestampAssignerSupplier.Context assignerContext() {
        return UnregisteredMetricsGroup::new;
    }

    static WatermarkGeneratorSupplier.Context generatorContext() {
        return new WatermarkGeneratorSupplier.Context(){

            public MetricGroup getMetricGroup() {
                return new UnregisteredMetricsGroup();
            }

            public RelativeClock getInputActivityClock() {
                return SystemClock.getInstance();
            }
        };
    }

    static class TestTimestampAssigner
    implements TimestampAssigner<Object>,
    Serializable {
        TestTimestampAssigner() {
        }

        public long extractTimestamp(Object element, long recordTimestamp) {
            return 42L;
        }
    }
}

