/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.File;
import java.io.IOException;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.api.common.io.FirstAttemptInitializationContext;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.IntValue;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FileOutputFormatTest {
    FileOutputFormatTest() {
    }

    @Test
    void testCreateNonParallelLocalFS() throws IOException {
        File tmpOutPath = File.createTempFile("fileOutputFormatTest", "Test1");
        File tmpOutFile = new File(tmpOutPath.getAbsolutePath() + "/1");
        String tmpFilePath = tmpOutPath.toURI().toString();
        Assertions.assertThatThrownBy(() -> {
            DummyFileOutputFormat dfof = new DummyFileOutputFormat();
            dfof.setOutputFilePath(new Path(tmpFilePath));
            dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
            dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
            dfof.configure(new Configuration());
            dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
            dfof.close();
        }).isInstanceOf(Exception.class);
        tmpOutPath.delete();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)tmpOutPath.mkdir()).as("Directory could not be created.", new Object[0])).isTrue();
        Assertions.assertThatThrownBy(() -> {
            DummyFileOutputFormat dfof = new DummyFileOutputFormat();
            dfof.setOutputFilePath(new Path(tmpFilePath));
            dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
            dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
            dfof.configure(new Configuration());
            dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
            dfof.close();
        }).isInstanceOf(Exception.class);
        tmpOutPath.delete();
        DummyFileOutputFormat dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isFile();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath + "/"));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isFile();
        tmpOutPath.delete();
        tmpOutPath.createNewFile();
        Assertions.assertThatThrownBy(() -> {
            DummyFileOutputFormat dfof = new DummyFileOutputFormat();
            dfof.setOutputFilePath(new Path(tmpFilePath));
            dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
            dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
            dfof.configure(new Configuration());
            dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
            dfof.close();
        }).isInstanceOf(Exception.class);
        tmpOutPath.delete();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)tmpOutPath.mkdir()).as("Directory could not be created.", new Object[0])).isTrue();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        new File(tmpOutPath.getAbsoluteFile() + "/1").delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.testFileName = true;
        Configuration c = new Configuration();
        dfof.configure(c);
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof.close();
        File customOutFile = new File(tmpOutPath.getAbsolutePath() + "/fancy-1-0.avro");
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)customOutFile).exists().isFile();
        customOutFile.delete();
        customOutFile = new File(tmpOutPath.getAbsolutePath() + "/1");
        customOutFile.createNewFile();
        Assertions.assertThatThrownBy(() -> {
            DummyFileOutputFormat dfof = new DummyFileOutputFormat();
            dfof.setOutputFilePath(new Path(tmpFilePath));
            dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
            dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
            dfof.configure(new Configuration());
            dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
            dfof.close();
        }).isInstanceOf(Exception.class);
        new File(tmpOutPath.getAbsoluteFile() + "/1").delete();
        tmpOutPath.delete();
        DummyFileOutputFormat dfof2 = new DummyFileOutputFormat();
        dfof2.setOutputFilePath(new Path(tmpFilePath));
        dfof2.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof2.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof2.configure(new Configuration());
        dfof2.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof2.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        new File(tmpOutPath.getAbsoluteFile() + "/1").delete();
        tmpOutPath.delete();
        dfof2 = new DummyFileOutputFormat();
        dfof2.setOutputFilePath(new Path(tmpFilePath + "/"));
        dfof2.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof2.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof2.configure(new Configuration());
        dfof2.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof2.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        new File(tmpOutPath.getAbsoluteFile() + "/1").delete();
        tmpOutPath.delete();
    }

    @Test
    void testCreateParallelLocalFS() throws IOException {
        File tmpOutPath = File.createTempFile("fileOutputFormatTest", "Test1");
        File tmpOutFile = new File(tmpOutPath.getAbsolutePath() + "/1");
        String tmpFilePath = tmpOutPath.toURI().toString();
        Assertions.assertThatThrownBy(() -> {
            DummyFileOutputFormat dfof = new DummyFileOutputFormat();
            dfof.setOutputFilePath(new Path(tmpFilePath));
            dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
            dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
            dfof.configure(new Configuration());
            dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)2));
            dfof.close();
        }).isInstanceOf(Exception.class);
        tmpOutPath.delete();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)tmpOutPath.mkdir()).as("Directory could not be created.", new Object[0])).isTrue();
        DummyFileOutputFormat dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)2));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        tmpOutFile.delete();
        tmpOutPath.delete();
        tmpOutPath.mkdir();
        tmpOutFile.createNewFile();
        Assertions.assertThatThrownBy(() -> {
            DummyFileOutputFormat dfof = new DummyFileOutputFormat();
            dfof.setOutputFilePath(new Path(tmpFilePath));
            dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
            dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
            dfof.configure(new Configuration());
            dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)2));
            dfof.close();
        }).isInstanceOf(Exception.class);
        tmpOutFile.delete();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)2));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        tmpOutFile.delete();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath + "/"));
        dfof.setWriteMode(FileSystem.WriteMode.NO_OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)2));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        tmpOutFile.delete();
        tmpOutPath.delete();
    }

    @Test
    void testOverwriteNonParallelLocalFS() throws IOException {
        File tmpOutPath = File.createTempFile("fileOutputFormatTest", "Test1");
        File tmpOutFile = new File(tmpOutPath.getAbsolutePath() + "/1");
        String tmpFilePath = tmpOutPath.toURI().toString();
        DummyFileOutputFormat dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isFile();
        tmpOutPath.delete();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)tmpOutPath.mkdir()).as("Directory could not be created.", new Object[0])).isTrue();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isFile();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isFile();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath + "/"));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isFile();
        tmpOutPath.delete();
        tmpOutPath.createNewFile();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        tmpOutFile.delete();
        tmpOutPath.delete();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)tmpOutPath.mkdir()).as("Directory could not be created.", new Object[0])).isTrue();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        tmpOutPath.delete();
        tmpOutFile.delete();
        tmpOutPath.mkdir();
        tmpOutFile.createNewFile();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        tmpOutPath.delete();
        tmpOutFile.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath + "/"));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        tmpOutFile.delete();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath + "/"));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.ALWAYS);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)1));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        tmpOutFile.delete();
        tmpOutPath.delete();
    }

    @Test
    void testOverwriteParallelLocalFS() throws IOException {
        File tmpOutPath = File.createTempFile("fileOutputFormatTest", "Test1");
        File tmpOutFile = new File(tmpOutPath.getAbsolutePath() + "/1");
        String tmpFilePath = tmpOutPath.toURI().toString();
        DummyFileOutputFormat dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)2));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        tmpOutFile.delete();
        tmpOutPath.delete();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)tmpOutPath.mkdir()).as("Directory could not be created.", new Object[0])).isTrue();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)2));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        tmpOutFile.delete();
        tmpOutPath.delete();
        tmpOutPath.mkdir();
        tmpOutFile.createNewFile();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)2));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        new File(tmpOutPath.getAbsoluteFile() + "/1").delete();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)2));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        tmpOutFile.delete();
        tmpOutPath.delete();
        dfof = new DummyFileOutputFormat();
        dfof.setOutputFilePath(new Path(tmpFilePath + "/"));
        dfof.setWriteMode(FileSystem.WriteMode.OVERWRITE);
        dfof.setOutputDirectoryMode(FileOutputFormat.OutputDirectoryMode.PARONLY);
        dfof.configure(new Configuration());
        dfof.open((OutputFormat.InitializationContext)FirstAttemptInitializationContext.of((int)0, (int)2));
        dfof.close();
        Assertions.assertThat((File)tmpOutPath).exists().isDirectory();
        Assertions.assertThat((File)tmpOutFile).exists().isFile();
        tmpOutFile.delete();
        tmpOutPath.delete();
    }

    public static class DummyFileOutputFormat
    extends FileOutputFormat<IntValue> {
        private static final long serialVersionUID = 1L;
        public boolean testFileName = false;

        public void writeRecord(IntValue record) {
        }

        protected String getDirectoryFileName(int taskNumber) {
            if (this.testFileName) {
                return "fancy-" + (taskNumber + 1) + "-" + taskNumber + ".avro";
            }
            return super.getDirectoryFileName(taskNumber);
        }
    }
}

