/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.util;

import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.operators.SlotSharingGroup;
import org.apache.flink.api.common.operators.util.SlotSharingGroupUtils;
import org.apache.flink.api.common.resources.ExternalResource;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SlotSharingGroupUtilsTest {
    SlotSharingGroupUtilsTest() {
    }

    @Test
    void testCovertToResourceSpec() {
        ExternalResource gpu = new ExternalResource("gpu", 1.0);
        ResourceSpec resourceSpec = ResourceSpec.newBuilder((double)1.0, (int)100).setManagedMemoryMB(200).setTaskOffHeapMemoryMB(300).setExtendedResource(gpu).build();
        SlotSharingGroup slotSharingGroup1 = SlotSharingGroup.newBuilder((String)"ssg").setCpuCores(resourceSpec.getCpuCores().getValue().doubleValue()).setTaskHeapMemory(resourceSpec.getTaskHeapMemory()).setTaskOffHeapMemory(resourceSpec.getTaskOffHeapMemory()).setManagedMemory(resourceSpec.getManagedMemory()).setExternalResource(gpu.getName(), gpu.getValue().doubleValue()).build();
        SlotSharingGroup slotSharingGroup2 = SlotSharingGroup.newBuilder((String)"ssg").build();
        Assertions.assertThat((Object)SlotSharingGroupUtils.extractResourceSpec((SlotSharingGroup)slotSharingGroup1)).isEqualTo((Object)resourceSpec);
        Assertions.assertThat((Object)SlotSharingGroupUtils.extractResourceSpec((SlotSharingGroup)slotSharingGroup2)).isEqualTo((Object)ResourceSpec.UNKNOWN);
    }
}

