/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.Serializable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MapStateDescriptorTest {
    MapStateDescriptorTest() {
    }

    @Test
    void testMapStateDescriptor() throws Exception {
        KryoSerializer keySerializer = new KryoSerializer(Integer.class, (SerializerConfig)new SerializerConfigImpl());
        KryoSerializer valueSerializer = new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl());
        MapStateDescriptor descr = new MapStateDescriptor("testName", (TypeSerializer)keySerializer, (TypeSerializer)valueSerializer);
        Assertions.assertThat((String)descr.getName()).isEqualTo("testName");
        Assertions.assertThat((Object)descr.getSerializer()).isNotNull();
        Assertions.assertThat((Object)descr.getSerializer()).isInstanceOf(MapSerializer.class);
        Assertions.assertThat((Object)descr.getKeySerializer()).isNotNull();
        Assertions.assertThat((Object)descr.getKeySerializer()).isEqualTo((Object)keySerializer);
        Assertions.assertThat((Object)descr.getValueSerializer()).isNotNull();
        Assertions.assertThat((Object)descr.getValueSerializer()).isEqualTo((Object)valueSerializer);
        MapStateDescriptor copy = (MapStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)descr);
        Assertions.assertThat((String)copy.getName()).isEqualTo("testName");
        Assertions.assertThat((Object)copy.getSerializer()).isNotNull();
        Assertions.assertThat((Object)copy.getSerializer()).isInstanceOf(MapSerializer.class);
        Assertions.assertThat((Object)copy.getKeySerializer()).isNotNull();
        Assertions.assertThat((Object)copy.getKeySerializer()).isEqualTo((Object)keySerializer);
        Assertions.assertThat((Object)copy.getValueSerializer()).isNotNull();
        Assertions.assertThat((Object)copy.getValueSerializer()).isEqualTo((Object)valueSerializer);
    }

    @Test
    void testHashCodeEquals() throws Exception {
        String name = "testName";
        MapStateDescriptor original = new MapStateDescriptor("testName", String.class, String.class);
        MapStateDescriptor same = new MapStateDescriptor("testName", String.class, String.class);
        MapStateDescriptor sameBySerializer = new MapStateDescriptor("testName", (TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
        Assertions.assertThat((Object)same).hasSameHashCodeAs((Object)original);
        Assertions.assertThat((Object)sameBySerializer).hasSameHashCodeAs((Object)original);
        Assertions.assertThat((Object)same).isEqualTo((Object)original);
        Assertions.assertThat((Object)sameBySerializer).isEqualTo((Object)original);
        MapStateDescriptor clone = (MapStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)original);
        Assertions.assertThat((Object)clone).isEqualTo((Object)original);
        clone.initializeSerializerUnlessSet(new ExecutionConfig());
        Assertions.assertThat((Object)clone).isEqualTo((Object)original);
        original.initializeSerializerUnlessSet(new ExecutionConfig());
        Assertions.assertThat((Object)same).isEqualTo((Object)original);
    }

    @Test
    void testSerializerDuplication() {
        KryoSerializer keySerializer = new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl());
        KryoSerializer valueSerializer = new KryoSerializer(Long.class, (SerializerConfig)new SerializerConfigImpl());
        MapStateDescriptor descr = new MapStateDescriptor("foobar", (TypeSerializer)keySerializer, (TypeSerializer)valueSerializer);
        TypeSerializer keySerializerA = descr.getKeySerializer();
        TypeSerializer keySerializerB = descr.getKeySerializer();
        TypeSerializer valueSerializerA = descr.getValueSerializer();
        TypeSerializer valueSerializerB = descr.getValueSerializer();
        Assertions.assertThat((Object)keySerializerB).isNotSameAs((Object)keySerializerA);
        Assertions.assertThat((Object)valueSerializerB).isNotSameAs((Object)valueSerializerA);
        TypeSerializer serializerA = descr.getSerializer();
        TypeSerializer serializerB = descr.getSerializer();
        Assertions.assertThat((Object)serializerB).isNotSameAs((Object)serializerA);
    }
}

