/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state.v2;

import java.io.Serializable;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.state.v2.AggregatingStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AggregatingStateDescriptorTest
implements Serializable {
    AggregatingStateDescriptorTest() {
    }

    @Test
    void testHashCodeAndEquals() throws Exception {
        String name = "testName";
        AggregateFunction<Integer, Integer, Integer> aggregator = new AggregateFunction<Integer, Integer, Integer>(){

            public Integer createAccumulator() {
                return 0;
            }

            public Integer add(Integer value, Integer accumulator) {
                return accumulator + value;
            }

            public Integer getResult(Integer accumulator) {
                return accumulator;
            }

            public Integer merge(Integer a, Integer b) {
                return a + b;
            }
        };
        AggregatingStateDescriptor original = new AggregatingStateDescriptor("testName", (AggregateFunction)aggregator, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        AggregatingStateDescriptor same = new AggregatingStateDescriptor("testName", (AggregateFunction)aggregator, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        AggregatingStateDescriptor sameBySerializer = new AggregatingStateDescriptor("testName", (AggregateFunction)aggregator, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)same).hasSameHashCodeAs((Object)original);
        Assertions.assertThat((Object)sameBySerializer).hasSameHashCodeAs((Object)original);
        Assertions.assertThat((Object)same).isEqualTo((Object)original);
        Assertions.assertThat((Object)sameBySerializer).isEqualTo((Object)original);
        AggregatingStateDescriptor clone = (AggregatingStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)original);
        Assertions.assertThat((Object)clone).isEqualTo((Object)original);
    }
}

