/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.NullableMapTypeInfo;

class NullableMapSerializerTest
extends SerializerTestBase<Map<Long, String>> {
    NullableMapSerializerTest() {
    }

    @Override
    protected TypeSerializer<Map<Long, String>> createSerializer() {
        return new NullableMapTypeInfo((TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO).createSerializer((SerializerConfig)new SerializerConfigImpl());
    }

    @Override
    protected int getLength() {
        return -1;
    }

    @Override
    protected Class<Map<Long, String>> getTypeClass() {
        return Map.class;
    }

    protected Map<Long, String>[] getTestData() {
        Random rnd = new Random(123654789L);
        Object map1 = null;
        Map map2 = Collections.emptyMap();
        HashMap map3 = new HashMap();
        Map<Long, String> map4 = Collections.singletonMap(0L, "hello");
        HashMap<Long, String> map5 = new HashMap<Long, String>();
        map5.put(12345L, "12345L");
        HashMap<Long, String> map6 = new HashMap<Long, String>();
        for (int i = 0; i < rnd.nextInt(200); ++i) {
            map6.put(rnd.nextLong(), Long.toString(rnd.nextLong()));
        }
        map6.put(rnd.nextLong(), null);
        map6.put(null, Long.toString(rnd.nextLong()));
        return new Map[]{map1, map2, map3, map4, map5, map6};
    }
}

