/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.SetSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.test.util.MigrationTest;
import org.assertj.core.api.Condition;

class SetSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<List<String>, List<String>> {
    private static final String SPEC_NAME = "set-serializer";

    SetSerializerUpgradeTest() {
    }

    @Override
    public Collection<FlinkVersion> getMigrationVersions() {
        return FlinkVersion.rangeOf((FlinkVersion)FlinkVersion.v2_0, (FlinkVersion)MigrationTest.getMostRecentlyPublishedVersion());
    }

    @Override
    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, flinkVersion, SetSerializerSetup.class, SetSerializerVerifier.class));
        return testSpecifications;
    }

    public static final class SetSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Set<String>> {
        @Override
        public TypeSerializer<Set<String>> createUpgradedSerializer() {
            return new SetSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        @Override
        public Condition<Set<String>> testDataCondition() {
            HashSet<String> data = new HashSet<String>(2);
            data.add("Apache");
            data.add("Flink");
            return new Condition(data::equals, "data is (Apache, Flink)", new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<Set<String>>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class SetSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Set<String>> {
        @Override
        public TypeSerializer<Set<String>> createPriorSerializer() {
            return new SetSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        @Override
        public Set<String> createTestData() {
            HashSet<String> data = new HashSet<String>(2);
            data.add("Apache");
            data.add("Flink");
            return data;
        }
    }
}

