/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CompositeTypeTest {
    private final TupleTypeInfo<?> tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
    private final TupleTypeInfo<Tuple3<Integer, String, Long>> inNestedTuple1 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
    private final TupleTypeInfo<Tuple2<Double, Double>> inNestedTuple2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO});
    private final TupleTypeInfo<?> nestedTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, this.inNestedTuple1, BasicTypeInfo.INT_TYPE_INFO, this.inNestedTuple2});
    private final TupleTypeInfo<Tuple2<Integer, Tuple2<Integer, Integer>>> inNestedTuple3 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO})});
    private final TupleTypeInfo<?> deepNestedTupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, this.inNestedTuple3, BasicTypeInfo.INT_TYPE_INFO});
    private final PojoTypeInfo<?> pojoTypeInfo = (PojoTypeInfo)TypeExtractor.getForClass(MyPojo.class);
    private final TupleTypeInfo<?> pojoInTupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, this.pojoTypeInfo});

    CompositeTypeTest() {
    }

    @Test
    void testGetFlatFields() {
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("0").get(0)).getPosition()).isZero();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("1").get(0)).getPosition()).isOne();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("2").get(0)).getPosition()).isEqualTo(2);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("3").get(0)).getPosition()).isEqualTo(3);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("f0").get(0)).getPosition()).isZero();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("f1").get(0)).getPosition()).isOne();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("f2").get(0)).getPosition()).isEqualTo(2);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.tupleTypeInfo.getFlatFields("f3").get(0)).getPosition()).isEqualTo(3);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("0").get(0)).getPosition()).isZero();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.0").get(0)).getPosition()).isOne();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.1").get(0)).getPosition()).isEqualTo(2);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.2").get(0)).getPosition()).isEqualTo(3);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("2").get(0)).getPosition()).isEqualTo(4);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("3.0").get(0)).getPosition()).isEqualTo(5);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("3.1").get(0)).getPosition()).isEqualTo(6);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f2").get(0)).getPosition()).isEqualTo(4);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f3.f0").get(0)).getPosition()).isEqualTo(5);
        Assertions.assertThat((List)this.nestedTypeInfo.getFlatFields("1")).hasSize(3);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1").get(0)).getPosition()).isOne();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1").get(1)).getPosition()).isEqualTo(2);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1").get(2)).getPosition()).isEqualTo(3);
        Assertions.assertThat((List)this.nestedTypeInfo.getFlatFields("1.*")).hasSize(3);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.*").get(0)).getPosition()).isOne();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.*").get(1)).getPosition()).isEqualTo(2);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.*").get(2)).getPosition()).isEqualTo(3);
        Assertions.assertThat((List)this.nestedTypeInfo.getFlatFields("3")).hasSize(2);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("3").get(0)).getPosition()).isEqualTo(5);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("3").get(1)).getPosition()).isEqualTo(6);
        Assertions.assertThat((List)this.nestedTypeInfo.getFlatFields("f1")).hasSize(3);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f1").get(0)).getPosition()).isOne();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f1").get(1)).getPosition()).isEqualTo(2);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f1").get(2)).getPosition()).isEqualTo(3);
        Assertions.assertThat((List)this.nestedTypeInfo.getFlatFields("f3")).hasSize(2);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f3").get(0)).getPosition()).isEqualTo(5);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("f3").get(1)).getPosition()).isEqualTo(6);
        Assertions.assertThat((Object)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("0").get(0)).getType()).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1.1").get(0)).getType()).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("1").get(2)).getType()).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((Object)((CompositeType.FlatFieldDescriptor)this.nestedTypeInfo.getFlatFields("3").get(1)).getType()).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
        Assertions.assertThat((List)this.deepNestedTupleTypeInfo.getFlatFields("1")).hasSize(3);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("1").get(0)).getPosition()).isOne();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("1").get(1)).getPosition()).isEqualTo(2);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("1").get(2)).getPosition()).isEqualTo(3);
        Assertions.assertThat((List)this.deepNestedTupleTypeInfo.getFlatFields("*")).hasSize(5);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("*").get(0)).getPosition()).isZero();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("*").get(1)).getPosition()).isOne();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("*").get(2)).getPosition()).isEqualTo(2);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("*").get(3)).getPosition()).isEqualTo(3);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.deepNestedTupleTypeInfo.getFlatFields("*").get(4)).getPosition()).isEqualTo(4);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.pojoTypeInfo.getFlatFields("a").get(0)).getPosition()).isZero();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.pojoTypeInfo.getFlatFields("b").get(0)).getPosition()).isOne();
        Assertions.assertThat((List)this.pojoTypeInfo.getFlatFields("*")).hasSize(2);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.pojoTypeInfo.getFlatFields("*").get(0)).getPosition()).isZero();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.pojoTypeInfo.getFlatFields("*").get(1)).getPosition()).isOne();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("f1.a").get(0)).getPosition()).isOne();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("1.b").get(0)).getPosition()).isEqualTo(2);
        Assertions.assertThat((List)this.pojoInTupleTypeInfo.getFlatFields("1")).hasSize(2);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("1.*").get(0)).getPosition()).isOne();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("1").get(1)).getPosition()).isEqualTo(2);
        Assertions.assertThat((List)this.pojoInTupleTypeInfo.getFlatFields("f1.*")).hasSize(2);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("f1.*").get(0)).getPosition()).isOne();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("f1").get(1)).getPosition()).isEqualTo(2);
        Assertions.assertThat((List)this.pojoInTupleTypeInfo.getFlatFields("*")).hasSize(3);
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("*").get(0)).getPosition()).isZero();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("*").get(1)).getPosition()).isOne();
        Assertions.assertThat((int)((CompositeType.FlatFieldDescriptor)this.pojoInTupleTypeInfo.getFlatFields("*").get(2)).getPosition()).isEqualTo(2);
    }

    @Test
    void testFieldAtStringRef() {
        Assertions.assertThat((Object)this.tupleTypeInfo.getTypeAt("0")).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)this.tupleTypeInfo.getTypeAt("2")).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)this.tupleTypeInfo.getTypeAt("f1")).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)this.tupleTypeInfo.getTypeAt("f3")).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)this.nestedTypeInfo.getTypeAt("0")).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)this.nestedTypeInfo.getTypeAt("1.0")).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)this.nestedTypeInfo.getTypeAt("1.1")).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)this.nestedTypeInfo.getTypeAt("1.2")).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((Object)this.nestedTypeInfo.getTypeAt("2")).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)this.nestedTypeInfo.getTypeAt("3.0")).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
        Assertions.assertThat((Object)this.nestedTypeInfo.getTypeAt("3.1")).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
        Assertions.assertThat((Object)this.nestedTypeInfo.getTypeAt("f2")).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)this.nestedTypeInfo.getTypeAt("f3.f0")).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
        Assertions.assertThat((Object)this.nestedTypeInfo.getTypeAt("1")).isEqualTo(this.inNestedTuple1);
        Assertions.assertThat((Object)this.nestedTypeInfo.getTypeAt("3")).isEqualTo(this.inNestedTuple2);
        Assertions.assertThat((Object)this.nestedTypeInfo.getTypeAt("f1")).isEqualTo(this.inNestedTuple1);
        Assertions.assertThat((Object)this.nestedTypeInfo.getTypeAt("f3")).isEqualTo(this.inNestedTuple2);
        Assertions.assertThat((Object)this.deepNestedTupleTypeInfo.getTypeAt("1")).isEqualTo(this.inNestedTuple3);
        Assertions.assertThat((Object)this.pojoTypeInfo.getTypeAt("a")).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)this.pojoTypeInfo.getTypeAt("b")).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)this.pojoInTupleTypeInfo.getTypeAt("f1.a")).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)this.pojoInTupleTypeInfo.getTypeAt("1.b")).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        Assertions.assertThat((Object)this.pojoInTupleTypeInfo.getTypeAt("1")).isEqualTo(this.pojoTypeInfo);
        Assertions.assertThat((Object)this.pojoInTupleTypeInfo.getTypeAt("f1")).isEqualTo(this.pojoTypeInfo);
    }

    public static class MyPojo {
        public String a;
        public int b;
    }
}

