/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.HashMap;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PojoParametrizedTypeExtractionTest {
    PojoParametrizedTypeExtractionTest() {
    }

    @Test
    void testDirectlyCreateTypeInfo() {
        TypeInformation directTypeInfo = TypeExtractor.createTypeInfo(ParameterizedParentImpl.class);
        Assertions.assertThat((Object)directTypeInfo).isEqualTo(this.getParameterizedParentTypeInformation());
    }

    @Test
    void testMapReturnTypeInfo() {
        TypeInformation<ParameterizedParentImpl> expectedTypeInfo = this.getParameterizedParentTypeInformation();
        TypeInformation mapReturnTypeInfo = TypeExtractor.getMapReturnTypes((MapFunction)new ConcreteMapFunction(), (TypeInformation)Types.INT);
        Assertions.assertThat((Object)mapReturnTypeInfo).isEqualTo(expectedTypeInfo);
    }

    private TypeInformation<ParameterizedParentImpl> getParameterizedParentTypeInformation() {
        HashMap<String, TypeInformation> nestedFields = new HashMap<String, TypeInformation>();
        nestedFields.put("digits", Types.INT);
        nestedFields.put("letters", Types.STRING);
        HashMap<String, TypeInformation> fields = new HashMap<String, TypeInformation>();
        fields.put("precise", Types.DOUBLE);
        fields.put("pojoField", Types.POJO(Pojo.class, nestedFields));
        return Types.POJO(ParameterizedParentImpl.class, fields);
    }

    public static class ConcreteMapFunction
    implements MapFunction<Integer, ParameterizedParentImpl> {
        public ParameterizedParentImpl map(Integer value) throws Exception {
            return null;
        }
    }

    public static class ParameterizedParentImpl
    extends ParameterizedParent<Pojo> {
        public double precise;
    }

    public static class ParameterizedParent<T> {
        public T pojoField;
    }

    public static class Pojo {
        public int digits;
        public String letters;
    }
}

