/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInfoFactory;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.EitherTypeInfo;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TypeInfoFactoryTest {
    @Test
    void testSimpleType() {
        TypeInformation ti = TypeExtractor.createTypeInfo(IntLike.class);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        ti = TypeExtractor.getForClass(IntLike.class);
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        ti = TypeExtractor.getForObject((Object)new IntLike());
        Assertions.assertThat((Object)ti).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
    }

    @Test
    void testMyEitherGenericType() {
        MyEitherMapper f = new MyEitherMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(f, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((Object)ti).isInstanceOf(EitherTypeInfo.class);
        EitherTypeInfo eti = (EitherTypeInfo)ti;
        Assertions.assertThat((Object)eti.getLeftType()).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((Object)eti.getRightType()).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    void testMyOptionGenericType() {
        MyOptionTypeInfo inTypeInfo = new MyOptionTypeInfo(new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.BOOLEAN_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}));
        MyOptionMapper f = new MyOptionMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(f, inTypeInfo);
        Assertions.assertThat((Object)ti).isInstanceOf(MyOptionTypeInfo.class);
        MyOptionTypeInfo oti = (MyOptionTypeInfo)ti;
        Assertions.assertThat((boolean)(oti.getInnerType() instanceof TupleTypeInfo)).isTrue();
        TupleTypeInfo tti = (TupleTypeInfo)oti.getInnerType();
        Assertions.assertThat((Object)tti.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((Object)tti.getTypeAt(1)).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testMyTuple() {
        TupleTypeInfo inTypeInfo = new TupleTypeInfo(new TypeInformation[]{new MyTupleTypeInfo((TypeInformation)BasicTypeInfo.DOUBLE_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO)});
        MyTupleMapperL2 f = new MyTupleMapperL2();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(f, (TypeInformation)inTypeInfo);
        Assertions.assertThat((Object)ti).isInstanceOf(TupleTypeInfo.class);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((boolean)(tti.getTypeAt(0) instanceof MyTupleTypeInfo)).isTrue();
        MyTupleTypeInfo mtti = (MyTupleTypeInfo)tti.getTypeAt(0);
        Assertions.assertThat((Object)mtti.getField0()).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((Object)mtti.getField1()).isEqualTo((Object)BasicTypeInfo.DOUBLE_TYPE_INFO);
    }

    @Test
    void testMyTupleHierarchy() {
        TypeInformation ti = TypeExtractor.createTypeInfo(MyTuple2.class);
        Assertions.assertThat((Object)ti).isInstanceOf(MyTupleTypeInfo.class);
        MyTupleTypeInfo mtti = (MyTupleTypeInfo)ti;
        Assertions.assertThat((Object)mtti.getField0()).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)mtti.getField1()).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testMyTupleHierarchyWithInference() {
        TupleTypeInfo inTypeInfo = new TupleTypeInfo(new TypeInformation[]{new MyTupleTypeInfo((TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.FLOAT_TYPE_INFO}), (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO)});
        MyTuple3Mapper f = new MyTuple3Mapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(f, (TypeInformation)inTypeInfo);
        Assertions.assertThat((Object)ti).isInstanceOf(TupleTypeInfo.class);
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assertions.assertThat((boolean)(tti.getTypeAt(0) instanceof MyTupleTypeInfo)).isTrue();
        MyTupleTypeInfo mtti = (MyTupleTypeInfo)tti.getTypeAt(0);
        Assertions.assertThat((Object)mtti.getField0()).isEqualTo((Object)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.FLOAT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}));
        Assertions.assertThat((Object)mtti.getField1()).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
    }

    @Test
    void testWithFieldTypeInfoAnnotation() {
        TypeInformation typeWithAnnotation = TypeInformation.of((TypeHint)new TypeHint<WithFieldTypeInfoAnnotation<Double, String>>(){});
        TypeInformation typeWithoutAnnotation = TypeInformation.of((TypeHint)new TypeHint<WithoutFieldTypeInfoAnnotation<Double, String>>(){});
        Assertions.assertThat((Object)typeWithAnnotation).isInstanceOf(PojoTypeInfo.class);
        Assertions.assertThat((Object)typeWithoutAnnotation).isInstanceOf(PojoTypeInfo.class);
        PojoTypeInfo pojoTypeWithAnnotation = (PojoTypeInfo)typeWithAnnotation;
        PojoTypeInfo pojoTypeWithoutAnnotation = (PojoTypeInfo)typeWithoutAnnotation;
        Assertions.assertThat((boolean)(pojoTypeWithAnnotation.getTypeAt(1) instanceof EitherTypeInfo)).isTrue();
        Assertions.assertThat((boolean)(pojoTypeWithoutAnnotation.getTypeAt(1) instanceof GenericTypeInfo)).isTrue();
        Assertions.assertThat((Object)pojoTypeWithAnnotation.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
        Assertions.assertThat((Object)pojoTypeWithoutAnnotation.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.INT_TYPE_INFO);
        WithFieldTypeInfoAnnotationMapper f = new WithFieldTypeInfoAnnotationMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(f, (TypeInformation)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((Object)ti).isInstanceOf(PojoTypeInfo.class);
        PojoTypeInfo tiPojo = (PojoTypeInfo)ti;
        Assertions.assertThat((boolean)(tiPojo.getTypeAt(1) instanceof EitherTypeInfo)).isTrue();
        EitherTypeInfo eti = (EitherTypeInfo)tiPojo.getTypeAt(1);
        Assertions.assertThat((Object)eti.getLeftType()).isEqualTo((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO);
        Assertions.assertThat((Object)eti.getRightType()).isEqualTo((Object)BasicTypeInfo.STRING_TYPE_INFO);
        Assertions.assertThat((Object)tiPojo.getTypeAt(0)).isEqualTo((Object)BasicTypeInfo.LONG_TYPE_INFO);
    }

    @Test
    void testMissingTypeInfo() {
        Assertions.assertThatThrownBy(() -> {
            MyFaultyMapper f = new MyFaultyMapper();
            TypeExtractor.getMapReturnTypes(f, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        }).isInstanceOf(InvalidTypesException.class);
    }

    @Test
    void testMissingTypeInference() {
        Assertions.assertThatThrownBy(() -> {
            MyFaultyMapper2 f = new MyFaultyMapper2();
            TypeExtractor.getMapReturnTypes(f, (TypeInformation)new MyFaultyTypeInfo());
        }).isInstanceOf(InvalidTypesException.class);
    }

    public static class WithFieldTypeInfoAnnotationMapper<T>
    implements MapFunction<T, WithFieldTypeInfoAnnotation<T, String>> {
        public WithFieldTypeInfoAnnotation<T, String> map(T value) throws Exception {
            return null;
        }
    }

    public static class WithoutFieldTypeInfoAnnotation<A, B> {
        public OuterEither<A, B> outerEither;
        public IntLike id;
    }

    public static class WithFieldTypeInfoAnnotation<A, B> {
        @TypeInfo(value=MyEitherTypeInfoFactory.class)
        public OuterEither<A, B> outerEither;
        @TypeInfo(value=IntLikeTypeInfoFactory2.class)
        public IntLike id;
    }

    public static class OuterEither<A, B> {
    }

    public static class IntLikeTypeInfoFactory2
    extends TypeInfoFactory<IntLike> {
        public TypeInformation<IntLike> createTypeInfo(Type t, Map<String, TypeInformation<?>> genericParams) {
            return BasicTypeInfo.LONG_TYPE_INFO;
        }
    }

    public static class IntLikeTypeInfoFactory
    extends TypeInfoFactory<IntLike> {
        public TypeInformation<IntLike> createTypeInfo(Type t, Map<String, TypeInformation<?>> genericParams) {
            return BasicTypeInfo.INT_TYPE_INFO;
        }
    }

    @TypeInfo(value=IntLikeTypeInfoFactory.class)
    public static class IntLike {
    }

    public static class MyEitherTypeInfoFactory<A, B>
    extends TypeInfoFactory<MyEither<A, B>> {
        public TypeInformation<MyEither<A, B>> createTypeInfo(Type t, Map<String, TypeInformation<?>> genericParams) {
            return new EitherTypeInfo(genericParams.get("A"), genericParams.get("B"));
        }
    }

    @TypeInfo(value=MyEitherTypeInfoFactory.class)
    public static class MyEither<A, B> {
    }

    public static class MyEitherMapper<T>
    implements MapFunction<T, MyEither<T, String>> {
        public MyEither<T, String> map(T value) throws Exception {
            return null;
        }
    }

    public static class MyOptionTypeInfo<T>
    extends TypeInformation<MyOption<T>> {
        private final TypeInformation<T> innerType;

        public MyOptionTypeInfo(TypeInformation<T> innerType) {
            this.innerType = innerType;
        }

        public TypeInformation<T> getInnerType() {
            return this.innerType;
        }

        public boolean isBasicType() {
            return false;
        }

        public boolean isTupleType() {
            return false;
        }

        public int getArity() {
            return 0;
        }

        public int getTotalFields() {
            return 1;
        }

        public Class<MyOption<T>> getTypeClass() {
            return null;
        }

        public boolean isKeyType() {
            return false;
        }

        public TypeSerializer<MyOption<T>> createSerializer(SerializerConfig config) {
            return null;
        }

        public String toString() {
            return null;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public boolean canEqual(Object obj) {
            return false;
        }

        public Map<String, TypeInformation<?>> getGenericParameters() {
            HashMap map = new HashMap(1);
            map.put("T", this.innerType);
            return map;
        }
    }

    public static class MyOptionTypeInfoFactory<T>
    extends TypeInfoFactory<MyOption<T>> {
        public TypeInformation<MyOption<T>> createTypeInfo(Type t, Map<String, TypeInformation<?>> genericParams) {
            return new MyOptionTypeInfo(genericParams.get("T"));
        }
    }

    @TypeInfo(value=MyOptionTypeInfoFactory.class)
    public static class MyOption<T> {
    }

    public static class MyOptionMapper<T>
    implements MapFunction<MyOption<Tuple2<T, String>>, MyOption<Tuple2<T, T>>> {
        public MyOption<Tuple2<T, T>> map(MyOption<Tuple2<T, String>> value) throws Exception {
            return null;
        }
    }

    public static class MyTupleTypeInfo<T0, T1>
    extends TypeInformation<MyTuple<T0, T1>> {
        private final TypeInformation field0;
        private final TypeInformation field1;

        public TypeInformation getField0() {
            return this.field0;
        }

        public TypeInformation getField1() {
            return this.field1;
        }

        public MyTupleTypeInfo(TypeInformation field0, TypeInformation field1) {
            this.field0 = field0;
            this.field1 = field1;
        }

        public boolean isBasicType() {
            return false;
        }

        public boolean isTupleType() {
            return false;
        }

        public int getArity() {
            return 0;
        }

        public int getTotalFields() {
            return 0;
        }

        public Class<MyTuple<T0, T1>> getTypeClass() {
            return null;
        }

        public boolean isKeyType() {
            return false;
        }

        public TypeSerializer<MyTuple<T0, T1>> createSerializer(SerializerConfig config) {
            return null;
        }

        public String toString() {
            return null;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public boolean canEqual(Object obj) {
            return false;
        }

        public Map<String, TypeInformation<?>> getGenericParameters() {
            HashMap map = new HashMap(2);
            map.put("T0", this.field0);
            map.put("T1", this.field1);
            return map;
        }
    }

    public static class MyTupleTypeInfoFactory
    extends TypeInfoFactory<MyTuple> {
        public TypeInformation<MyTuple> createTypeInfo(Type t, Map<String, TypeInformation<?>> genericParameters) {
            return new MyTupleTypeInfo(genericParameters.get("T0"), genericParameters.get("T1"));
        }
    }

    @TypeInfo(value=MyTupleTypeInfoFactory.class)
    public static class MyTuple<T0, T1> {
    }

    public static class MyTupleMapperL2<C>
    extends MyTupleMapperL1<C, Boolean> {
    }

    public static class MyTupleMapperL1<A, B>
    implements MapFunction<Tuple1<MyTuple<A, String>>, Tuple1<MyTuple<B, A>>> {
        public Tuple1<MyTuple<B, A>> map(Tuple1<MyTuple<A, String>> value) throws Exception {
            return null;
        }
    }

    public static class MyFaultyTypeInfo
    extends TypeInformation<MyFaulty> {
        public boolean isBasicType() {
            return false;
        }

        public boolean isTupleType() {
            return false;
        }

        public int getArity() {
            return 0;
        }

        public int getTotalFields() {
            return 0;
        }

        public Class<MyFaulty> getTypeClass() {
            return null;
        }

        public boolean isKeyType() {
            return false;
        }

        public TypeSerializer<MyFaulty> createSerializer(SerializerConfig config) {
            return null;
        }

        public String toString() {
            return null;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public boolean canEqual(Object obj) {
            return false;
        }
    }

    public static class FaultyTypeInfoFactory
    extends TypeInfoFactory {
        public TypeInformation createTypeInfo(Type t, Map genericParameters) {
            return null;
        }
    }

    @TypeInfo(value=FaultyTypeInfoFactory.class)
    public static class MyFaulty<Y> {
    }

    public static class MyFaultyMapper<T>
    implements MapFunction<T, MyFaulty<T>> {
        public MyFaulty<T> map(T value) throws Exception {
            return null;
        }
    }

    public static class MyFaultyMapper2<T>
    implements MapFunction<MyFaulty<T>, MyFaulty<T>> {
        public MyFaulty<T> map(MyFaulty<T> value) throws Exception {
            return null;
        }
    }

    public static class MyTuple2
    extends MyTuple<String, Boolean> {
    }

    public static class MyTuple3<T>
    extends MyTuple<T, Boolean> {
    }

    public static class MyTuple3Mapper<Y>
    implements MapFunction<Tuple1<MyTuple3<Tuple1<Y>>>, Tuple1<MyTuple3<Tuple2<Y, String>>>> {
        public Tuple1<MyTuple3<Tuple2<Y, String>>> map(Tuple1<MyTuple3<Tuple1<Y>>> value) throws Exception {
            return null;
        }
    }
}

