/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Random;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.AbstractGenericTypeSerializerTest;
import org.apache.flink.util.StringUtils;
import org.junit.jupiter.api.Test;

public abstract class AbstractGenericArraySerializerTest {
    private final Random rnd = new Random(349712539451944123L);

    @Test
    void testString() {
        String[] arr1 = new String[]{"abc", "", StringUtils.getRandomString((Random)new Random(289347567856686223L), (int)10, (int)100), StringUtils.getRandomString((Random)new Random(289347567856686223L), (int)15, (int)50), StringUtils.getRandomString((Random)new Random(289347567856686223L), (int)30, (int)170), StringUtils.getRandomString((Random)new Random(289347567856686223L), (int)14, (int)15), ""};
        String[] arr2 = new String[]{"foo", "", StringUtils.getRandomString((Random)new Random(289347567856686223L), (int)10, (int)100), StringUtils.getRandomString((Random)new Random(289347567856686223L), (int)1000, (int)5000), StringUtils.getRandomString((Random)new Random(289347567856686223L), (int)30000, (int)35000), StringUtils.getRandomString((Random)new Random(289347567856686223L), (int)102400, (int)107520), "bar"};
        this.runTests((Class)String.class, (TypeSerializer)new StringSerializer(), (T[][])new String[][]{arr1, arr2});
        this.runTests(arr1, arr2);
    }

    @Test
    void testSimpleTypesObjects() {
        AbstractGenericTypeSerializerTest.SimpleTypes a = new AbstractGenericTypeSerializerTest.SimpleTypes();
        AbstractGenericTypeSerializerTest.SimpleTypes b = new AbstractGenericTypeSerializerTest.SimpleTypes(this.rnd.nextInt(), this.rnd.nextLong(), (byte)this.rnd.nextInt(), StringUtils.getRandomString((Random)this.rnd, (int)10, (int)100), (short)this.rnd.nextInt(), this.rnd.nextDouble());
        AbstractGenericTypeSerializerTest.SimpleTypes c = new AbstractGenericTypeSerializerTest.SimpleTypes(this.rnd.nextInt(), this.rnd.nextLong(), (byte)this.rnd.nextInt(), StringUtils.getRandomString((Random)this.rnd, (int)10, (int)100), (short)this.rnd.nextInt(), this.rnd.nextDouble());
        AbstractGenericTypeSerializerTest.SimpleTypes d = new AbstractGenericTypeSerializerTest.SimpleTypes(this.rnd.nextInt(), this.rnd.nextLong(), (byte)this.rnd.nextInt(), StringUtils.getRandomString((Random)this.rnd, (int)10, (int)100), (short)this.rnd.nextInt(), this.rnd.nextDouble());
        AbstractGenericTypeSerializerTest.SimpleTypes e = new AbstractGenericTypeSerializerTest.SimpleTypes(this.rnd.nextInt(), this.rnd.nextLong(), (byte)this.rnd.nextInt(), StringUtils.getRandomString((Random)this.rnd, (int)10, (int)100), (short)this.rnd.nextInt(), this.rnd.nextDouble());
        AbstractGenericTypeSerializerTest.SimpleTypes f = new AbstractGenericTypeSerializerTest.SimpleTypes(this.rnd.nextInt(), this.rnd.nextLong(), (byte)this.rnd.nextInt(), StringUtils.getRandomString((Random)this.rnd, (int)10, (int)100), (short)this.rnd.nextInt(), this.rnd.nextDouble());
        AbstractGenericTypeSerializerTest.SimpleTypes g = new AbstractGenericTypeSerializerTest.SimpleTypes(this.rnd.nextInt(), this.rnd.nextLong(), (byte)this.rnd.nextInt(), StringUtils.getRandomString((Random)this.rnd, (int)10, (int)100), (short)this.rnd.nextInt(), this.rnd.nextDouble());
        this.runTests({a, b, c}, {d, e, f, g});
    }

    @Test
    void testCompositeObject() {
        AbstractGenericTypeSerializerTest.ComplexNestedObject1 o1 = new AbstractGenericTypeSerializerTest.ComplexNestedObject1(5626435);
        AbstractGenericTypeSerializerTest.ComplexNestedObject1 o2 = new AbstractGenericTypeSerializerTest.ComplexNestedObject1(76923);
        AbstractGenericTypeSerializerTest.ComplexNestedObject1 o3 = new AbstractGenericTypeSerializerTest.ComplexNestedObject1(-1100);
        AbstractGenericTypeSerializerTest.ComplexNestedObject1 o4 = new AbstractGenericTypeSerializerTest.ComplexNestedObject1(0);
        AbstractGenericTypeSerializerTest.ComplexNestedObject1 o5 = new AbstractGenericTypeSerializerTest.ComplexNestedObject1(44);
        this.runTests({o1, o2}, {o3}, {o4, o5});
    }

    @Test
    void testNestedObjects() {
        AbstractGenericTypeSerializerTest.ComplexNestedObject2 o1 = new AbstractGenericTypeSerializerTest.ComplexNestedObject2(this.rnd);
        AbstractGenericTypeSerializerTest.ComplexNestedObject2 o2 = new AbstractGenericTypeSerializerTest.ComplexNestedObject2();
        AbstractGenericTypeSerializerTest.ComplexNestedObject2 o3 = new AbstractGenericTypeSerializerTest.ComplexNestedObject2(this.rnd);
        AbstractGenericTypeSerializerTest.ComplexNestedObject2 o4 = new AbstractGenericTypeSerializerTest.ComplexNestedObject2(this.rnd);
        this.runTests({o1, o2, o3}, new AbstractGenericTypeSerializerTest.ComplexNestedObject2[0], new AbstractGenericTypeSerializerTest.ComplexNestedObject2[0], {o4}, new AbstractGenericTypeSerializerTest.ComplexNestedObject2[0]);
    }

    @Test
    void testBeanStyleObjects() {
        AbstractGenericTypeSerializerTest.Book b1 = new AbstractGenericTypeSerializerTest.Book(976243875L, "The Serialization Odyssey", 42L);
        AbstractGenericTypeSerializerTest.Book b2 = new AbstractGenericTypeSerializerTest.Book(0L, "Debugging byte streams", 1337L);
        AbstractGenericTypeSerializerTest.Book b3 = new AbstractGenericTypeSerializerTest.Book(-1L, "Low level interfaces", 12648430L);
        AbstractGenericTypeSerializerTest.Book b4 = new AbstractGenericTypeSerializerTest.Book(Long.MAX_VALUE, "The joy of bits and bytes", -559038737L);
        AbstractGenericTypeSerializerTest.Book b5 = new AbstractGenericTypeSerializerTest.Book(Long.MIN_VALUE, "Winning a prize for creative test strings", 12246784L);
        AbstractGenericTypeSerializerTest.Book b6 = new AbstractGenericTypeSerializerTest.Book(-2L, "Distributed Systems", -6066930334832433271L);
        this.runTests({b1, b2}, new AbstractGenericTypeSerializerTest.Book[0], new AbstractGenericTypeSerializerTest.Book[0], new AbstractGenericTypeSerializerTest.Book[0], new AbstractGenericTypeSerializerTest.Book[0], {b3, b4, b5, b6});
        ArrayList<String> list = new ArrayList<String>();
        list.add("A");
        list.add("B");
        list.add("C");
        list.add("D");
        list.add("E");
        AbstractGenericTypeSerializerTest.BookAuthor b12 = new AbstractGenericTypeSerializerTest.BookAuthor(976243875L, list, "Arno Nym");
        ArrayList<String> list2 = new ArrayList<String>();
        AbstractGenericTypeSerializerTest.BookAuthor b22 = new AbstractGenericTypeSerializerTest.BookAuthor(987654321L, list2, "The Saurus");
        this.runTests(new AbstractGenericTypeSerializerTest.BookAuthor[][]{{b12, b22}});
    }

    @SafeVarargs
    private final <T> void runTests(T[] ... instances) {
        Class<?> type = instances[0][0].getClass();
        TypeSerializer<?> serializer = this.createComponentSerializer(type);
        this.runTests(type, serializer, instances);
    }

    @SafeVarargs
    private final <T> void runTests(Class<T> type, TypeSerializer<T> componentSerializer, T[] ... instances) {
        if (type == null || componentSerializer == null || instances == null || instances.length == 0) {
            throw new IllegalArgumentException();
        }
        Class<?> arrayClass = Array.newInstance(type, 0).getClass();
        GenericArraySerializer<T> serializer = this.createSerializer(type, componentSerializer);
        SerializerTestInstance<T[]> test = new SerializerTestInstance<T[]>(serializer, arrayClass, -1, (Object[][])instances){};
        test.testAll();
    }

    private <T> GenericArraySerializer<T> createSerializer(Class<T> type, TypeSerializer<T> componentSerializer) {
        return new GenericArraySerializer(type, componentSerializer);
    }

    protected abstract <T> TypeSerializer<T> createComponentSerializer(Class<T> var1);
}

