/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.NullableSerializer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

abstract class NullableSerializerTest
extends SerializerTestBase<Integer> {
    private static final TypeSerializer<Integer> originalSerializer = IntSerializer.INSTANCE;
    private TypeSerializer<Integer> nullableSerializer;

    NullableSerializerTest() {
    }

    @BeforeEach
    void init() {
        this.nullableSerializer = NullableSerializer.wrapIfNullIsNotSupported(originalSerializer, (boolean)this.isPaddingNullValue());
    }

    @Override
    protected TypeSerializer<Integer> createSerializer() {
        return NullableSerializer.wrapIfNullIsNotSupported(originalSerializer, (boolean)this.isPaddingNullValue());
    }

    @Override
    protected int getLength() {
        return this.isPaddingNullValue() ? 5 : -1;
    }

    @Override
    protected Class<Integer> getTypeClass() {
        return Integer.class;
    }

    protected Integer[] getTestData() {
        return new Integer[]{5, -1, null, 5};
    }

    @Test
    void testWrappingNotNeeded() {
        Assertions.assertThat((Object)NullableSerializer.wrapIfNullIsNotSupported((TypeSerializer)StringSerializer.INSTANCE, (boolean)this.isPaddingNullValue())).isEqualTo((Object)StringSerializer.INSTANCE);
    }

    @Test
    void testWrappingNeeded() {
        ((ObjectAssert)Assertions.assertThat(this.nullableSerializer).isInstanceOf(NullableSerializer.class)).isEqualTo((Object)NullableSerializer.wrapIfNullIsNotSupported(this.nullableSerializer, (boolean)this.isPaddingNullValue()));
    }

    abstract boolean isPaddingNullValue();

    static final class NullableSerializerWithoutPaddingTest
    extends NullableSerializerTest {
        NullableSerializerWithoutPaddingTest() {
        }

        @Override
        boolean isPaddingNullValue() {
            return false;
        }
    }

    static final class NullableSerializerWithPaddingTest
    extends NullableSerializerTest {
        NullableSerializerWithPaddingTest() {
        }

        @Override
        boolean isPaddingNullValue() {
            return true;
        }
    }
}

