/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.Objects;
import java.util.Random;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.junit.jupiter.api.Test;

class PojoSubclassSerializerTest
extends SerializerTestBase<TestUserClassBase> {
    private final TypeInformation<TestUserClassBase> type = TypeExtractor.getForClass(TestUserClassBase.class);

    PojoSubclassSerializerTest() {
    }

    @Override
    protected TypeSerializer<TestUserClassBase> createSerializer() {
        SerializerConfigImpl conf = new SerializerConfigImpl();
        conf.registerPojoType(TestUserClass1.class);
        TypeSerializer serializer = this.type.createSerializer((SerializerConfig)conf);
        assert (serializer instanceof PojoSerializer);
        return serializer;
    }

    @Override
    protected int getLength() {
        return -1;
    }

    @Override
    protected Class<TestUserClassBase> getTypeClass() {
        return TestUserClassBase.class;
    }

    protected TestUserClassBase[] getTestData() {
        Random rnd = new Random(874597969123412341L);
        return new TestUserClassBase[]{new TestUserClass1(rnd.nextInt(), "foo", rnd.nextLong()), new TestUserClass2(rnd.nextInt(), "bar", rnd.nextFloat()), new TestUserClass3(rnd.nextInt(), "bar", rnd.nextFloat())};
    }

    @Override
    @Test
    protected void testInstantiate() {
    }

    public static class TestUserClass3
    extends TestUserClassBase {
        public float dumm4;

        public TestUserClass3(int dumm1, String dumm2, float dumm4) {
            super(dumm1, dumm2);
            this.dumm4 = dumm4;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof TestUserClass3)) {
                return false;
            }
            TestUserClass3 otherTUC = (TestUserClass3)other;
            if (this.dumm1 != otherTUC.dumm1) {
                return false;
            }
            if (!this.dumm2.equals(otherTUC.dumm2)) {
                return false;
            }
            return this.dumm4 == otherTUC.dumm4;
        }
    }

    public static class TestUserClass2
    extends TestUserClassBase {
        public float dumm4;

        public TestUserClass2() {
        }

        public TestUserClass2(int dumm1, String dumm2, float dumm4) {
            super(dumm1, dumm2);
            this.dumm4 = dumm4;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof TestUserClass2)) {
                return false;
            }
            TestUserClass2 otherTUC = (TestUserClass2)other;
            if (this.dumm1 != otherTUC.dumm1) {
                return false;
            }
            if (!this.dumm2.equals(otherTUC.dumm2)) {
                return false;
            }
            return this.dumm4 == otherTUC.dumm4;
        }
    }

    public static class TestUserClass1
    extends TestUserClassBase {
        public long dumm3;

        public TestUserClass1() {
        }

        public TestUserClass1(int dumm1, String dumm2, long dumm3) {
            super(dumm1, dumm2);
            this.dumm3 = dumm3;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof TestUserClass1)) {
                return false;
            }
            TestUserClass1 otherTUC = (TestUserClass1)other;
            if (this.dumm1 != otherTUC.dumm1) {
                return false;
            }
            if (!this.dumm2.equals(otherTUC.dumm2)) {
                return false;
            }
            return this.dumm3 == otherTUC.dumm3;
        }
    }

    public static abstract class TestUserClassBase {
        public int dumm1;
        public String dumm2;

        public TestUserClassBase() {
        }

        public TestUserClassBase(int dumm1, String dumm2) {
            this.dumm1 = dumm1;
            this.dumm2 = dumm2;
        }

        public int hashCode() {
            return Objects.hash(this.dumm1, this.dumm2);
        }

        public boolean equals(Object other) {
            if (!(other instanceof TestUserClassBase)) {
                return false;
            }
            TestUserClassBase otherTUC = (TestUserClassBase)other;
            if (this.dumm1 != otherTUC.dumm1) {
                return false;
            }
            return this.dumm2.equals(otherTUC.dumm2);
        }
    }
}

