/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConditions;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoPojosForMigrationTests;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.assertj.core.api.Condition;

class KryoSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Object, Object> {
    KryoSerializerUpgradeTest() {
    }

    @Override
    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications(FlinkVersion flinkVersion) throws Exception {
        ArrayList testSpecifications = new ArrayList();
        if (flinkVersion.isNewerVersionThan(FlinkVersion.v2_0) || flinkVersion == FlinkVersion.v2_0) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("kryo-type-serializer-empty-config", flinkVersion, KryoTypeSerializerEmptyConfigSetup.class, KryoTypeSerializerEmptyConfigVerifier.class));
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("kryo-type-serializer-unrelated-config-after-restore", flinkVersion, KryoTypeSerializerEmptyConfigSetup.class, KryoTypeSerializerWithUnrelatedConfigVerifier.class));
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("kryo-type-serializer-changed-registration-order", flinkVersion, KryoTypeSerializerChangedRegistrationOrderSetup.class, KryoTypeSerializerChangedRegistrationOrderVerifier.class));
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("kryo-custom-type-serializer-changed-registration-order", flinkVersion, KryoCustomTypeSerializerChangedRegistrationOrderSetup.class, KryoCustomTypeSerializerChangedRegistrationOrderVerifier.class));
        }
        return testSpecifications;
    }

    public static final class DummyClassTwo {
    }

    public static final class DummyClassOne {
    }

    public static final class KryoCustomTypeSerializerChangedRegistrationOrderVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createUpgradedSerializer() {
            SerializerConfigImpl serializerConfigImpl = new SerializerConfigImpl();
            serializerConfigImpl.registerKryoType(DummyClassOne.class);
            serializerConfigImpl.registerTypeWithKryoSerializer(KryoPojosForMigrationTests.Dog.class, KryoPojosForMigrationTests.DogV2KryoSerializer.class);
            serializerConfigImpl.registerKryoType(DummyClassTwo.class);
            serializerConfigImpl.registerKryoType(KryoPojosForMigrationTests.Cat.class);
            serializerConfigImpl.registerTypeWithKryoSerializer(KryoPojosForMigrationTests.Parrot.class, KryoPojosForMigrationTests.ParrotKryoSerializer.class);
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)serializerConfigImpl);
        }

        @Override
        public Condition<KryoPojosForMigrationTests.Animal> testDataCondition() {
            return new Condition(value -> new KryoPojosForMigrationTests.Dog("Hasso").equals(value), "value should be a Dog with name 'Hasso'", new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<KryoPojosForMigrationTests.Animal>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.hasSameCompatibilityAs(TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer((TypeSerializer)new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)new SerializerConfigImpl())));
        }
    }

    public static final class KryoCustomTypeSerializerChangedRegistrationOrderSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createPriorSerializer() {
            SerializerConfigImpl serializerConfigImpl = new SerializerConfigImpl();
            serializerConfigImpl.registerTypeWithKryoSerializer(KryoPojosForMigrationTests.Dog.class, KryoPojosForMigrationTests.DogKryoSerializer.class);
            serializerConfigImpl.registerKryoType(KryoPojosForMigrationTests.Cat.class);
            serializerConfigImpl.registerTypeWithKryoSerializer(KryoPojosForMigrationTests.Parrot.class, KryoPojosForMigrationTests.ParrotKryoSerializer.class);
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)serializerConfigImpl);
        }

        @Override
        public KryoPojosForMigrationTests.Animal createTestData() {
            return new KryoPojosForMigrationTests.Dog("Hasso");
        }
    }

    public static final class KryoTypeSerializerChangedRegistrationOrderVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createUpgradedSerializer() {
            SerializerConfigImpl serializerConfigImpl = new SerializerConfigImpl();
            serializerConfigImpl.registerKryoType(DummyClassOne.class);
            serializerConfigImpl.registerKryoType(KryoPojosForMigrationTests.Dog.class);
            serializerConfigImpl.registerKryoType(DummyClassTwo.class);
            serializerConfigImpl.registerKryoType(KryoPojosForMigrationTests.Cat.class);
            serializerConfigImpl.registerKryoType(KryoPojosForMigrationTests.Parrot.class);
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)serializerConfigImpl);
        }

        @Override
        public Condition<KryoPojosForMigrationTests.Animal> testDataCondition() {
            return new Condition(value -> new KryoPojosForMigrationTests.Dog("Hasso").equals(value), "value should be a Dog with name 'Hasso'", new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<KryoPojosForMigrationTests.Animal>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.hasSameCompatibilityAs(TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer((TypeSerializer)new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)new SerializerConfigImpl())));
        }
    }

    public static final class KryoTypeSerializerChangedRegistrationOrderSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createPriorSerializer() {
            SerializerConfigImpl serializerConfigImpl = new SerializerConfigImpl();
            serializerConfigImpl.registerKryoType(KryoPojosForMigrationTests.Dog.class);
            serializerConfigImpl.registerKryoType(KryoPojosForMigrationTests.Cat.class);
            serializerConfigImpl.registerKryoType(KryoPojosForMigrationTests.Parrot.class);
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)serializerConfigImpl);
        }

        @Override
        public KryoPojosForMigrationTests.Animal createTestData() {
            return new KryoPojosForMigrationTests.Dog("Hasso");
        }
    }

    public static final class KryoTypeSerializerWithUnrelatedConfigVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createUpgradedSerializer() {
            SerializerConfigImpl serializerConfigImpl = new SerializerConfigImpl();
            serializerConfigImpl.registerKryoType(DummyClassOne.class);
            serializerConfigImpl.registerTypeWithKryoSerializer(DummyClassTwo.class, DefaultSerializers.StringSerializer.class);
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)serializerConfigImpl);
        }

        @Override
        public Condition<KryoPojosForMigrationTests.Animal> testDataCondition() {
            return new Condition(value -> new KryoPojosForMigrationTests.Dog("Hasso").equals(value), "value should be a Dog with name 'Hasso'", new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<KryoPojosForMigrationTests.Animal>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.hasSameCompatibilityAs(TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer((TypeSerializer)new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)new SerializerConfigImpl())));
        }
    }

    public static final class KryoTypeSerializerEmptyConfigVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createUpgradedSerializer() {
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)new SerializerConfigImpl());
        }

        @Override
        public Condition<KryoPojosForMigrationTests.Animal> testDataCondition() {
            return new Condition(value -> new KryoPojosForMigrationTests.Dog("Hasso").equals(value), "value should be a Dog with name 'Hasso'", new Object[0]);
        }

        @Override
        public Condition<TypeSerializerSchemaCompatibility<KryoPojosForMigrationTests.Animal>> schemaCompatibilityCondition(FlinkVersion version) {
            return TypeSerializerConditions.isCompatibleAsIs();
        }
    }

    public static final class KryoTypeSerializerEmptyConfigSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createPriorSerializer() {
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, (SerializerConfig)new SerializerConfigImpl());
        }

        @Override
        public KryoPojosForMigrationTests.Animal createTestData() {
            return new KryoPojosForMigrationTests.Dog("Hasso");
        }
    }
}

