/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.util.HashSet;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.AbstractGenericTypeSerializerTest;
import org.joda.time.LocalDate;
import org.junit.jupiter.api.Test;

class KryoWithCustomSerializersTest
extends AbstractGenericTypeSerializerTest {
    KryoWithCustomSerializersTest() {
    }

    @Test
    void testJodaTime() {
        HashSet<LocalDate> b = new HashSet<LocalDate>();
        b.add(new LocalDate(1L));
        b.add(new LocalDate(2L));
        this.runTests(b);
    }

    @Override
    protected <T> TypeSerializer<T> createSerializer(Class<T> type) {
        SerializerConfigImpl conf = new SerializerConfigImpl();
        conf.registerTypeWithKryoSerializer(LocalDate.class, LocalDateSerializer.class);
        GenericTypeInfo typeInfo = new GenericTypeInfo(type);
        return typeInfo.createSerializer((SerializerConfig)conf);
    }

    public static final class LocalDateSerializer
    extends Serializer<LocalDate>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void write(Kryo kryo, Output output, LocalDate object) {
            output.writeInt(object.getYear());
            output.writeInt(object.getMonthOfYear());
            output.writeInt(object.getDayOfMonth());
        }

        public LocalDate read(Kryo kryo, Input input, Class<? extends LocalDate> type) {
            return new LocalDate(input.readInt(), input.readInt(), input.readInt());
        }
    }
}

