/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.Serializers;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SerializersTest {
    SerializersTest() {
    }

    @Test
    void testTypeRegistration() {
        SerializerConfigImpl conf = new SerializerConfigImpl();
        Serializers.recursivelyRegisterType(ClassWithNested.class, (SerializerConfig)conf, new HashSet());
        KryoSerializer kryo = new KryoSerializer(String.class, (SerializerConfig)conf);
        Assertions.assertThat((int)kryo.getKryo().getRegistration(FromNested.class).getId()).isPositive();
        Assertions.assertThat((int)kryo.getKryo().getRegistration(ClassWithNested.class).getId()).isPositive();
        Assertions.assertThat((int)kryo.getKryo().getRegistration(Path.class).getId()).isPositive();
        Assertions.assertThat((int)kryo.getKryo().getRegistration(FromGeneric1.class).getId()).isPositive();
        Assertions.assertThat((int)kryo.getKryo().getRegistration(FromGeneric2.class).getId()).isPositive();
        Assertions.assertThat((int)kryo.getKryo().getRegistration(Node.class).getId()).isPositive();
        SerializerConfigImpl conf2 = new SerializerConfigImpl();
        Serializers.recursivelyRegisterType(ClassWithNested.class, (SerializerConfig)conf2, new HashSet());
        KryoSerializer kryo2 = new KryoSerializer(String.class, (SerializerConfig)conf);
        Assertions.assertThat((int)kryo2.getKryo().getRegistration(FromNested.class).getId()).isPositive();
    }

    @Test
    void testTypeRegistrationFromTypeInfo() {
        SerializerConfigImpl conf = new SerializerConfigImpl();
        Serializers.recursivelyRegisterType((TypeInformation)new GenericTypeInfo(ClassWithNested.class), (SerializerConfig)conf, new HashSet());
        KryoSerializer kryo = new KryoSerializer(String.class, (SerializerConfig)conf);
        Assertions.assertThat((int)kryo.getKryo().getRegistration(FromNested.class).getId()).isPositive();
        Assertions.assertThat((int)kryo.getKryo().getRegistration(ClassWithNested.class).getId()).isPositive();
        Assertions.assertThat((int)kryo.getKryo().getRegistration(Path.class).getId()).isPositive();
        Assertions.assertThat((int)kryo.getKryo().getRegistration(FromGeneric1.class).getId()).isPositive();
        Assertions.assertThat((int)kryo.getKryo().getRegistration(FromGeneric2.class).getId()).isPositive();
        Assertions.assertThat((int)kryo.getKryo().getRegistration(Node.class).getId()).isPositive();
    }

    public static class ClassWithNested {
        Nested1 nested;
        int ab;
        ArrayList<FromGeneric1> addGenType;
        FromGeneric2[] genericArrayType;
    }

    public static class Nested1 {
        private FromNested fromNested;
        private Path yodaInterval;
    }

    public static class FromGeneric2 {
    }

    public static class FromGeneric1 {
    }

    public static class FromNested {
        Node recurseMe;
    }

    public static class Node {
        private Node parent;
    }
}

