/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PathTest {
    PathTest() {
    }

    @Test
    void testPathFromString() {
        Path p = new Path("/my/path");
        Assertions.assertThat((String)p.toUri().getPath()).isEqualTo("/my/path");
        Assertions.assertThat((String)p.toUri().getScheme()).isNull();
        p = new Path("/my/path/");
        Assertions.assertThat((String)p.toUri().getPath()).isEqualTo("/my/path");
        Assertions.assertThat((String)p.toUri().getScheme()).isNull();
        p = new Path("/my//path/");
        Assertions.assertThat((String)p.toUri().getPath()).isEqualTo("/my/path");
        Assertions.assertThat((String)p.toUri().getScheme()).isNull();
        p = new Path("/my//path//a///");
        Assertions.assertThat((String)p.toUri().getPath()).isEqualTo("/my/path/a");
        Assertions.assertThat((String)p.toUri().getScheme()).isNull();
        p = new Path("\\my\\path\\\\a\\\\\\");
        Assertions.assertThat((String)p.toUri().getPath()).isEqualTo("/my/path/a");
        Assertions.assertThat((String)p.toUri().getScheme()).isNull();
        p = new Path("hdfs:///my/path");
        Assertions.assertThat((String)p.toUri().getPath()).isEqualTo("/my/path");
        Assertions.assertThat((String)p.toUri().getScheme()).isEqualTo("hdfs");
        p = new Path("hdfs:///my/path/");
        Assertions.assertThat((String)p.toUri().getPath()).isEqualTo("/my/path");
        Assertions.assertThat((String)p.toUri().getScheme()).isEqualTo("hdfs");
        p = new Path("file:///my/path");
        Assertions.assertThat((String)p.toUri().getPath()).isEqualTo("/my/path");
        Assertions.assertThat((String)p.toUri().getScheme()).isEqualTo("file");
        p = new Path("C:/my/windows/path");
        Assertions.assertThat((String)p.toUri().getPath()).isEqualTo("/C:/my/windows/path");
        p = new Path("file:/C:/my/windows/path");
        Assertions.assertThat((String)p.toUri().getPath()).isEqualTo("/C:/my/windows/path");
        Assertions.assertThatThrownBy(() -> new Path((String)null)).isInstanceOf(Exception.class);
        Assertions.assertThatThrownBy(() -> new Path("")).isInstanceOf(Exception.class);
    }

    @Test
    void testIsAbsolute() {
        Path p = new Path("/my/abs/path");
        Assertions.assertThat((boolean)p.isAbsolute()).isTrue();
        p = new Path("/");
        Assertions.assertThat((boolean)p.isAbsolute()).isTrue();
        p = new Path("./my/rel/path");
        Assertions.assertThat((boolean)p.isAbsolute()).isFalse();
        p = new Path("my/rel/path");
        Assertions.assertThat((boolean)p.isAbsolute()).isFalse();
        p = new Path("C:/my/abs/windows/path");
        Assertions.assertThat((boolean)p.isAbsolute()).isTrue();
        p = new Path("y:/my/abs/windows/path");
        Assertions.assertThat((boolean)p.isAbsolute()).isTrue();
        p = new Path("/y:/my/abs/windows/path");
        Assertions.assertThat((boolean)p.isAbsolute()).isTrue();
        p = new Path("b:\\my\\abs\\windows\\path");
        Assertions.assertThat((boolean)p.isAbsolute()).isTrue();
        p = new Path("/c:/my/dir");
        Assertions.assertThat((boolean)p.isAbsolute()).isTrue();
        p = new Path("/C:/");
        Assertions.assertThat((boolean)p.isAbsolute()).isTrue();
        p = new Path("C:");
        Assertions.assertThat((boolean)p.isAbsolute()).isFalse();
        p = new Path("C:/");
        Assertions.assertThat((boolean)p.isAbsolute()).isTrue();
        p = new Path("C:my\\relative\\path");
        Assertions.assertThat((boolean)p.isAbsolute()).isFalse();
        p = new Path("\\my\\dir");
        Assertions.assertThat((boolean)p.isAbsolute()).isTrue();
        p = new Path("\\");
        Assertions.assertThat((boolean)p.isAbsolute()).isTrue();
        p = new Path(".\\my\\relative\\path");
        Assertions.assertThat((boolean)p.isAbsolute()).isFalse();
        p = new Path("my\\relative\\path");
        Assertions.assertThat((boolean)p.isAbsolute()).isFalse();
        p = new Path("\\\\myServer\\myDir");
        Assertions.assertThat((boolean)p.isAbsolute()).isTrue();
    }

    @Test
    void testGetName() {
        Path p = new Path("/my/fancy/path");
        Assertions.assertThat((String)p.getName()).isEqualTo("path");
        p = new Path("/my/fancy/path/");
        Assertions.assertThat((String)p.getName()).isEqualTo("path");
        p = new Path("hdfs:///my/path");
        Assertions.assertThat((String)p.getName()).isEqualTo("path");
        p = new Path("hdfs:///myPath/");
        Assertions.assertThat((String)p.getName()).isEqualTo("myPath");
        p = new Path("/");
        Assertions.assertThat((String)p.getName()).isEmpty();
        p = new Path("C:/my/windows/path");
        Assertions.assertThat((String)p.getName()).isEqualTo("path");
        p = new Path("file:/C:/my/windows/path");
        Assertions.assertThat((String)p.getName()).isEqualTo("path");
    }

    @Test
    void testGetParent() {
        Path p = new Path("/my/fancy/path");
        Assertions.assertThat((String)p.getParent().toUri().getPath()).isEqualTo("/my/fancy");
        p = new Path("/my/other/fancy/path/");
        Assertions.assertThat((String)p.getParent().toUri().getPath()).isEqualTo("/my/other/fancy");
        p = new Path("hdfs:///my/path");
        Assertions.assertThat((String)p.getParent().toUri().getPath()).isEqualTo("/my");
        p = new Path("hdfs:///myPath/");
        Assertions.assertThat((String)p.getParent().toUri().getPath()).isEqualTo("/");
        p = new Path("/");
        Assertions.assertThat((Object)p.getParent()).isNull();
        p = new Path("C:/my/windows/path");
        Assertions.assertThat((String)p.getParent().toUri().getPath()).isEqualTo("/C:/my/windows");
    }

    @Test
    void testSuffix() {
        Path p = new Path("/my/path");
        p = p.suffix("_123");
        Assertions.assertThat((String)p.toUri().getPath()).isEqualTo("/my/path_123");
        p = new Path("/my/path/");
        p = p.suffix("/abc");
        Assertions.assertThat((String)p.toUri().getPath()).isEqualTo("/my/path/abc");
        p = new Path("C:/my/windows/path");
        p = p.suffix("/abc");
        Assertions.assertThat((String)p.toUri().getPath()).isEqualTo("/C:/my/windows/path/abc");
    }

    @Test
    void testDepth() {
        Path p = new Path("/my/path");
        Assertions.assertThat((int)p.depth()).isEqualTo(2);
        p = new Path("/my/fancy/path/");
        Assertions.assertThat((int)p.depth()).isEqualTo(3);
        p = new Path("/my/fancy/fancy/fancy/fancy/fancy/fancy/fancy/fancy/fancy/fancy/path");
        Assertions.assertThat((int)p.depth()).isEqualTo(12);
        p = new Path("/");
        Assertions.assertThat((int)p.depth()).isZero();
        p = new Path("C:/my/windows/path");
        Assertions.assertThat((int)p.depth()).isEqualTo(4);
    }

    @Test
    void testParsing() {
        String scheme = "hdfs";
        String authority = "localhost:8000";
        String path = "/test/test";
        URI u = new Path(scheme + "://" + authority + path).toUri();
        Assertions.assertThat((String)u.getScheme()).isEqualTo(scheme);
        Assertions.assertThat((String)u.getAuthority()).isEqualTo(authority);
        Assertions.assertThat((String)u.getPath()).isEqualTo(path);
        u = new Path(scheme + "://" + path).toUri();
        Assertions.assertThat((String)u.getScheme()).isEqualTo(scheme);
        Assertions.assertThat((String)u.getAuthority()).isNull();
        Assertions.assertThat((String)u.getPath()).isEqualTo(path);
        u = new Path(scheme + ":" + path).toUri();
        Assertions.assertThat((String)u.getScheme()).isEqualTo(scheme);
        Assertions.assertThat((String)u.getAuthority()).isNull();
        Assertions.assertThat((String)u.getPath()).isEqualTo(path);
        u = new Path(scheme + ":/" + path).toUri();
        Assertions.assertThat((String)u.getScheme()).isEqualTo(scheme);
        Assertions.assertThat((String)u.getAuthority()).isEqualTo("test");
        Assertions.assertThat((String)u.getPath()).isEqualTo("/test");
        u = new Path(scheme + ":///" + path).toUri();
        Assertions.assertThat((String)u.getScheme()).isEqualTo("hdfs");
        Assertions.assertThat((String)u.getAuthority()).isNull();
        Assertions.assertThat((String)u.getPath()).isEqualTo(path);
    }

    @Test
    void testMakeQualified() throws IOException {
        String path = "test/test";
        Path p = new Path(path).makeQualified(FileSystem.getLocalFileSystem());
        URI u = p.toUri();
        Assertions.assertThat((String)u.getScheme()).isEqualTo("file");
        Assertions.assertThat((String)u.getAuthority()).isNull();
        String q = new Path(FileSystem.getLocalFileSystem().getWorkingDirectory().getPath(), path).getPath();
        Assertions.assertThat((String)u.getPath()).isEqualTo(q);
        path = "/test/test";
        p = new Path(path).makeQualified(FileSystem.getLocalFileSystem());
        u = p.toUri();
        Assertions.assertThat((String)u.getScheme()).isEqualTo("file");
        Assertions.assertThat((String)u.getAuthority()).isNull();
        Assertions.assertThat((String)u.getPath()).isEqualTo(path);
    }
}

