/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.shaded.guava33.com.google.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class SimpleVersionedSerializationTest {
    SimpleVersionedSerializationTest() {
    }

    @Test
    void testSerializationRoundTrip() throws IOException {
        TestStringSerializer utfEncoder = new TestStringSerializer();
        String testString = "dugfakgs";
        DataOutputSerializer out = new DataOutputSerializer(32);
        SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)utfEncoder, (Object)"dugfakgs", (DataOutputView)out);
        byte[] outBytes = out.getCopyOfBuffer();
        byte[] bytes = SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)utfEncoder, (Object)"dugfakgs");
        Assertions.assertThat((byte[])outBytes).containsExactly(bytes);
        DataInputDeserializer in = new DataInputDeserializer(bytes);
        String deserialized = (String)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)utfEncoder, (DataInputView)in);
        String deserializedFromBytes = (String)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)utfEncoder, (byte[])outBytes);
        Assertions.assertThat((String)deserialized).isEqualTo("dugfakgs");
        Assertions.assertThat((String)deserializedFromBytes).isEqualTo("dugfakgs");
    }

    @Test
    void testSerializeEmpty() throws IOException {
        String testString = "beeeep!";
        SimpleVersionedSerializer<String> emptySerializer = new SimpleVersionedSerializer<String>(){

            public int getVersion() {
                return 42;
            }

            public byte[] serialize(String obj) throws IOException {
                return new byte[0];
            }

            public String deserialize(int version, byte[] serialized) throws IOException {
                Assertions.assertThat((int)version).isEqualTo(42);
                Assertions.assertThat((byte[])serialized).isEmpty();
                return "beeeep!";
            }
        };
        DataOutputSerializer out = new DataOutputSerializer(32);
        SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)emptySerializer, (Object)"abc", (DataOutputView)out);
        byte[] outBytes = out.getCopyOfBuffer();
        byte[] bytes = SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)emptySerializer, (Object)"abc");
        Assertions.assertThat((byte[])outBytes).containsExactly(bytes);
        DataInputDeserializer in = new DataInputDeserializer(bytes);
        String deserialized = (String)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)emptySerializer, (DataInputView)in);
        String deserializedFromBytes = (String)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)emptySerializer, (byte[])outBytes);
        Assertions.assertThat((String)deserialized).isEqualTo("beeeep!");
        Assertions.assertThat((String)deserializedFromBytes).isEqualTo("beeeep!");
    }

    @Test
    void testListSerializationRoundTrip() throws IOException {
        TestStringSerializer utfEncoder = new TestStringSerializer();
        ImmutableList datums = ImmutableList.of((Object)"beeep!", (Object)"beep!!!");
        DataOutputSerializer out = new DataOutputSerializer(32);
        SimpleVersionedSerialization.writeVersionAndSerializeList((SimpleVersionedSerializer)utfEncoder, (List)datums, (DataOutputView)out);
        byte[] outBytes = out.getCopyOfBuffer();
        DataInputDeserializer in = new DataInputDeserializer(outBytes);
        List deserialized = SimpleVersionedSerialization.readVersionAndDeserializeList((SimpleVersionedSerializer)utfEncoder, (DataInputView)in);
        Assertions.assertThat((List)deserialized).isEqualTo((Object)datums);
    }

    @Test
    void testUnderflow() throws Exception {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)new TestStringSerializer(), (byte[])new byte[7]));
    }

    private static final class TestStringSerializer
    implements SimpleVersionedSerializer<String> {
        private static final int VERSION = 0x3FFFFFFF;

        private TestStringSerializer() {
        }

        public int getVersion() {
            return 0x3FFFFFFF;
        }

        public byte[] serialize(String str) throws IOException {
            return str.getBytes(StandardCharsets.UTF_8);
        }

        public String deserialize(int version, byte[] serialized) throws IOException {
            Assertions.assertThat((int)version).isEqualTo(0x3FFFFFFF);
            return new String(serialized, StandardCharsets.UTF_8);
        }
    }
}

