/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Random;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.testutils.serialization.types.SerializationTestType;
import org.apache.flink.testutils.serialization.types.SerializationTestTypeFactory;
import org.apache.flink.testutils.serialization.types.Util;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DataInputOutputSerializerTest {
    DataInputOutputSerializerTest() {
    }

    @Test
    void testWrapAsByteBuffer() throws IOException {
        SerializationTestType randomInt = Util.randomRecord(SerializationTestTypeFactory.INT);
        DataOutputSerializer serializer = new DataOutputSerializer(randomInt.length());
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)randomInt.length());
        ByteBuffer wrapper = serializer.wrapAsByteBuffer();
        Assertions.assertThat((int)wrapper.position()).isZero();
        Assertions.assertThat((int)wrapper.limit()).isZero();
        randomInt.write((DataOutputView)serializer);
        Assertions.assertThat((int)wrapper.position()).isZero();
        Assertions.assertThat((int)wrapper.limit()).isZero();
        wrapper = serializer.wrapAsByteBuffer();
        Assertions.assertThat((int)wrapper.position()).isZero();
        Assertions.assertThat((int)wrapper.limit()).isEqualTo(randomInt.length());
        serializer.clear();
        Assertions.assertThat((int)wrapper.position()).isZero();
        Assertions.assertThat((int)wrapper.limit()).isEqualTo(randomInt.length());
        wrapper = serializer.wrapAsByteBuffer();
        Assertions.assertThat((int)wrapper.position()).isZero();
        Assertions.assertThat((int)wrapper.limit()).isZero();
        randomInt.write((DataOutputView)serializer);
        wrapper = serializer.wrapAsByteBuffer();
        segment.put(0, wrapper, randomInt.length());
        Assertions.assertThat((int)wrapper.position()).isEqualTo(randomInt.length());
        Assertions.assertThat((int)wrapper.limit()).isEqualTo(randomInt.length());
    }

    @Test
    void testRandomValuesWriteRead() throws IOException, InstantiationException, IllegalAccessException {
        int numElements = 100000;
        ArrayDeque<SerializationTestType> reference = new ArrayDeque<SerializationTestType>();
        DataOutputSerializer serializer = new DataOutputSerializer(1);
        for (SerializationTestType value : Util.randomRecords(100000)) {
            reference.add(value);
            value.write((DataOutputView)serializer);
        }
        DataInputDeserializer deserializer = new DataInputDeserializer(serializer.wrapAsByteBuffer());
        for (SerializationTestType expected : reference) {
            SerializationTestType actual = (SerializationTestType)expected.getClass().newInstance();
            actual.read((DataInputView)deserializer);
            Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
        }
        reference.clear();
    }

    @Test
    void testLongUTFWriteRead() throws IOException {
        byte[] array = new byte[1000];
        new Random(1L).nextBytes(array);
        String expected = new String(array, Charset.forName("UTF-8"));
        DataOutputSerializer serializer = new DataOutputSerializer(1);
        serializer.writeLongUTF(expected);
        DataInputDeserializer deserializer = new DataInputDeserializer(serializer.getSharedBuffer());
        String actual = deserializer.readLongUTF();
        Assertions.assertThat((String)actual).isEqualTo(expected);
    }

    @Test
    void testUTFWriteRead() throws IOException {
        byte[] array = new byte[1000];
        new Random(1L).nextBytes(array);
        String expected = new String(array, StandardCharsets.UTF_8);
        DataOutputSerializer serializer = new DataOutputSerializer(1);
        serializer.writeUTF(expected);
        DataInputDeserializer deserializer = new DataInputDeserializer(serializer.getSharedBuffer());
        String actual = deserializer.readUTF();
        Assertions.assertThat((String)actual).isEqualTo(expected);
    }
}

