/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.types.parser.TestFieldParser;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FieldParserTest {
    FieldParserTest() {
    }

    @Test
    void testDelimiterNext() {
        byte[] bytes = "aaabc".getBytes();
        byte[] delim = "aa".getBytes();
        Assertions.assertThat((boolean)FieldParser.delimiterNext((byte[])bytes, (int)0, (byte[])delim)).isTrue();
        Assertions.assertThat((boolean)FieldParser.delimiterNext((byte[])bytes, (int)1, (byte[])delim)).isTrue();
        Assertions.assertThat((boolean)FieldParser.delimiterNext((byte[])bytes, (int)2, (byte[])delim)).isFalse();
    }

    @Test
    void testEndsWithDelimiter() {
        byte[] bytes = "aabc".getBytes();
        byte[] delim = "ab".getBytes();
        Assertions.assertThat((boolean)FieldParser.endsWithDelimiter((byte[])bytes, (int)0, (byte[])delim)).isFalse();
        Assertions.assertThat((boolean)FieldParser.endsWithDelimiter((byte[])bytes, (int)1, (byte[])delim)).isFalse();
        Assertions.assertThat((boolean)FieldParser.endsWithDelimiter((byte[])bytes, (int)2, (byte[])delim)).isTrue();
        Assertions.assertThat((boolean)FieldParser.endsWithDelimiter((byte[])bytes, (int)3, (byte[])delim)).isFalse();
    }

    @Test
    void testNextStringEndPos() {
        TestFieldParser parser = new TestFieldParser();
        byte[] singleCharDelim = "|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        byte[] bytes1 = "a|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        Assertions.assertThat((int)parser.nextStringEndPos(bytes1, 0, bytes1.length, singleCharDelim)).isOne();
        Assertions.assertThat((int)parser.nextStringEndPos(bytes1, 1, bytes1.length, singleCharDelim)).isEqualTo(-1);
        Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.EMPTY_COLUMN);
        parser.resetParserState();
        Assertions.assertThat((int)parser.nextStringEndPos(bytes1, 1, 1, singleCharDelim)).isEqualTo(-1);
        Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.EMPTY_COLUMN);
        parser.resetParserState();
        Assertions.assertThat((int)parser.nextStringEndPos(bytes1, 2, bytes1.length, singleCharDelim)).isEqualTo(-1);
        Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.EMPTY_COLUMN);
        byte[] bytes2 = "a||".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assertions.assertThat((int)parser.nextStringEndPos(bytes2, 1, bytes2.length, singleCharDelim)).isEqualTo(-1);
        Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.EMPTY_COLUMN);
        byte[] bytes3 = "a|c".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assertions.assertThat((int)parser.nextStringEndPos(bytes3, 1, bytes3.length, singleCharDelim)).isEqualTo(-1);
        Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.EMPTY_COLUMN);
        parser.resetParserState();
        Assertions.assertThat((int)parser.nextStringEndPos(bytes3, 2, bytes3.length, singleCharDelim)).isEqualTo(3);
        Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.NONE);
        byte[] bytes4 = "a|c|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assertions.assertThat((int)parser.nextStringEndPos(bytes4, 2, bytes4.length, singleCharDelim)).isEqualTo(3);
        Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.NONE);
        byte[] multiCharDelim = "|#|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        byte[] mBytes1 = "a|#|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assertions.assertThat((int)parser.nextStringEndPos(mBytes1, 0, mBytes1.length, multiCharDelim)).isOne();
        Assertions.assertThat((int)parser.nextStringEndPos(mBytes1, 1, mBytes1.length, multiCharDelim)).isEqualTo(-1);
        Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.EMPTY_COLUMN);
        parser.resetParserState();
        Assertions.assertThat((int)parser.nextStringEndPos(mBytes1, 1, 1, multiCharDelim)).isEqualTo(-1);
        Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.EMPTY_COLUMN);
        byte[] mBytes2 = "a|#||#|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assertions.assertThat((int)parser.nextStringEndPos(mBytes2, 1, mBytes2.length, multiCharDelim)).isEqualTo(-1);
        Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.EMPTY_COLUMN);
        byte[] mBytes3 = "a|#|b".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assertions.assertThat((int)parser.nextStringEndPos(mBytes3, 1, mBytes3.length, multiCharDelim)).isEqualTo(-1);
        Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.EMPTY_COLUMN);
        parser.resetParserState();
        Assertions.assertThat((int)parser.nextStringEndPos(mBytes3, 2, mBytes3.length, multiCharDelim)).isEqualTo(5);
        Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.NONE);
        byte[] mBytes4 = "a|#|b|#|".getBytes(ConfigConstants.DEFAULT_CHARSET);
        parser.resetParserState();
        Assertions.assertThat((int)parser.nextStringEndPos(mBytes4, 2, mBytes4.length, multiCharDelim)).isEqualTo(5);
        Assertions.assertThat((Comparable)parser.getErrorState()).isEqualTo((Object)FieldParser.ParseErrorState.NONE);
    }
}

