/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.variant;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.flink.types.variant.BinaryVariant;
import org.apache.flink.types.variant.BinaryVariantInternalBuilder;
import org.apache.flink.types.variant.VariantTypeException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BinaryVariantInternalBuilderTest {
    BinaryVariantInternalBuilderTest() {
    }

    @Test
    void testParseScalarJson() throws IOException {
        Assertions.assertThat((byte)BinaryVariantInternalBuilder.parseJson((String)"1", (boolean)false).getByte()).isEqualTo((byte)1);
        short s = 128;
        Assertions.assertThat((short)BinaryVariantInternalBuilder.parseJson((String)String.valueOf(s), (boolean)false).getShort()).isEqualTo(s);
        int i = 32768;
        Assertions.assertThat((int)BinaryVariantInternalBuilder.parseJson((String)String.valueOf(i), (boolean)false).getInt()).isEqualTo(i);
        long l = 0x80000000L;
        Assertions.assertThat((long)BinaryVariantInternalBuilder.parseJson((String)String.valueOf(l), (boolean)false).getLong()).isEqualTo(l);
        BigDecimal bigDecimal = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.ONE);
        Assertions.assertThat((BigDecimal)BinaryVariantInternalBuilder.parseJson((String)bigDecimal.toPlainString(), (boolean)false).getDecimal()).isEqualTo((Object)bigDecimal);
        Assertions.assertThat((BigDecimal)BinaryVariantInternalBuilder.parseJson((String)"1.123", (boolean)false).getDecimal()).isEqualTo((Object)BigDecimal.valueOf(1.123));
        Assertions.assertThat((double)BinaryVariantInternalBuilder.parseJson((String)String.valueOf(Double.MAX_VALUE), (boolean)false).getDouble()).isEqualTo(Double.MAX_VALUE);
        Assertions.assertThat((String)BinaryVariantInternalBuilder.parseJson((String)"\"hello\"", (boolean)false).getString()).isEqualTo("hello");
        Assertions.assertThat((boolean)BinaryVariantInternalBuilder.parseJson((String)"true", (boolean)false).getBoolean()).isTrue();
        Assertions.assertThat((boolean)BinaryVariantInternalBuilder.parseJson((String)"false", (boolean)false).getBoolean()).isFalse();
        Assertions.assertThat((boolean)BinaryVariantInternalBuilder.parseJson((String)"null", (boolean)false).isNull()).isTrue();
    }

    @Test
    void testParseJsonArray() throws IOException {
        BinaryVariant variant = BinaryVariantInternalBuilder.parseJson((String)"[]", (boolean)false);
        Assertions.assertThat((Object)variant.getElement(0)).isNull();
        variant = BinaryVariantInternalBuilder.parseJson((String)"[1,\"hello\",3.1, null]", (boolean)false);
        Assertions.assertThat((byte)variant.getElement(0).getByte()).isEqualTo((byte)1);
        Assertions.assertThat((String)variant.getElement(1).getString()).isEqualTo("hello");
        Assertions.assertThat((BigDecimal)variant.getElement(2).getDecimal()).isEqualTo((Object)BigDecimal.valueOf(3.1));
        Assertions.assertThat((boolean)variant.getElement(3).isNull()).isTrue();
        variant = BinaryVariantInternalBuilder.parseJson((String)"[1,[\"hello\",[3.1]]]", (boolean)false);
        Assertions.assertThat((byte)variant.getElement(0).getByte()).isEqualTo((byte)1);
        Assertions.assertThat((String)variant.getElement(1).getElement(0).getString()).isEqualTo("hello");
        Assertions.assertThat((BigDecimal)variant.getElement(1).getElement(1).getElement(0).getDecimal()).isEqualTo((Object)BigDecimal.valueOf(3.1));
    }

    @Test
    void testParseJsonObject() throws IOException {
        BinaryVariant variant = BinaryVariantInternalBuilder.parseJson((String)"{}", (boolean)false);
        Assertions.assertThat((Object)variant.getField("a")).isNull();
        variant = BinaryVariantInternalBuilder.parseJson((String)"{\"a\":1,\"b\":\"hello\",\"c\":3.1}", (boolean)false);
        Assertions.assertThat((byte)variant.getField("a").getByte()).isEqualTo((byte)1);
        Assertions.assertThat((String)variant.getField("b").getString()).isEqualTo("hello");
        Assertions.assertThat((BigDecimal)variant.getField("c").getDecimal()).isEqualTo((Object)BigDecimal.valueOf(3.1));
        variant = BinaryVariantInternalBuilder.parseJson((String)"{\"a\":1,\"b\":{\"c\":\"hello\",\"d\":[3.1]}}", (boolean)false);
        Assertions.assertThat((byte)variant.getField("a").getByte()).isEqualTo((byte)1);
        Assertions.assertThat((String)variant.getField("b").getField("c").getString()).isEqualTo("hello");
        Assertions.assertThat((BigDecimal)variant.getField("b").getField("d").getElement(0).getDecimal()).isEqualTo((Object)BigDecimal.valueOf(3.1));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BinaryVariantInternalBuilder.parseJson((String)"{\"k1\":1,\"k1\":2,\"k2\":1.5}", (boolean)false)).isInstanceOf(VariantTypeException.class)).hasMessage("VARIANT_DUPLICATE_KEY");
        variant = BinaryVariantInternalBuilder.parseJson((String)"{\"k1\":1,\"k1\":2,\"k2\":1.5}", (boolean)true);
        Assertions.assertThat((byte)variant.getField("k1").getByte()).isEqualTo((byte)2);
        Assertions.assertThat((BigDecimal)variant.getField("k2").getDecimal()).isEqualTo((Object)BigDecimal.valueOf(1.5));
    }
}

