/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.variant;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.apache.flink.types.variant.BinaryVariant;
import org.apache.flink.types.variant.BinaryVariantBuilder;
import org.apache.flink.types.variant.Variant;
import org.apache.flink.types.variant.VariantTypeException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BinaryVariantTest {
    private BinaryVariantBuilder builder;

    BinaryVariantTest() {
    }

    @BeforeEach
    void setUp() {
        this.builder = new BinaryVariantBuilder();
    }

    @Test
    void testScalarVariant() {
        Assertions.assertThat((boolean)this.builder.of((byte)10).isPrimitive()).isTrue();
        Assertions.assertThat((boolean)this.builder.of((byte)10).isNull()).isFalse();
        Assertions.assertThat((boolean)this.builder.of((byte)10).isArray()).isFalse();
        Assertions.assertThat((boolean)this.builder.of((byte)10).isObject()).isFalse();
        Assertions.assertThat((Comparable)this.builder.of((byte)10).getType()).isEqualTo((Object)Variant.Type.TINYINT);
        Assertions.assertThat((byte)this.builder.of((byte)10).getByte()).isEqualTo((byte)10);
        Assertions.assertThat((Object)this.builder.of((byte)10).get()).isEqualTo((Object)10);
        Assertions.assertThat((byte)((Byte)this.builder.of((byte)10).getAs())).isEqualTo((byte)10);
        Assertions.assertThat((short)this.builder.of((short)10).getShort()).isEqualTo((short)10);
        Assertions.assertThat((Object)this.builder.of((short)10).get()).isEqualTo((Object)10);
        Assertions.assertThat((int)this.builder.of(10).getInt()).isEqualTo(10);
        Assertions.assertThat((Object)this.builder.of(10).get()).isEqualTo((Object)10);
        Assertions.assertThat((long)this.builder.of(10L).getLong()).isEqualTo(10L);
        Assertions.assertThat((Object)this.builder.of(10L).get()).isEqualTo((Object)10L);
        Assertions.assertThat((double)this.builder.of(10.0).getDouble()).isEqualTo(10.0);
        Assertions.assertThat((Object)this.builder.of(10.0).get()).isEqualTo((Object)10.0);
        Assertions.assertThat((float)this.builder.of(10.0f).getFloat()).isEqualTo(10.0f);
        Assertions.assertThat((Object)this.builder.of(10.0f).get()).isEqualTo((Object)Float.valueOf(10.0f));
        Assertions.assertThat((String)this.builder.of("hello").getString()).isEqualTo("hello");
        Assertions.assertThat((Object)this.builder.of("hello").get()).isEqualTo((Object)"hello");
        Assertions.assertThat((byte[])this.builder.of("hello".getBytes()).getBytes()).isEqualTo((Object)"hello".getBytes());
        Assertions.assertThat((Object)this.builder.of("hello".getBytes()).get()).isEqualTo((Object)"hello".getBytes());
        Assertions.assertThat((boolean)this.builder.of(true).getBoolean()).isTrue();
        Assertions.assertThat((Object)this.builder.of(true).get()).isEqualTo((Object)true);
        Assertions.assertThat((BigDecimal)this.builder.of(BigDecimal.valueOf(100L)).getDecimal()).isEqualByComparingTo((Comparable)BigDecimal.valueOf(100L));
        Assertions.assertThat((BigDecimal)((BigDecimal)this.builder.of(BigDecimal.valueOf(100L)).get())).isEqualByComparingTo((Comparable)BigDecimal.valueOf(100L));
        Instant instant = Instant.now().truncatedTo(ChronoUnit.MICROS);
        Assertions.assertThat((Instant)this.builder.of(instant).getInstant()).isEqualTo((Object)instant);
        Assertions.assertThat((Object)this.builder.of(instant).get()).isEqualTo((Object)instant);
        LocalDateTime localDateTime = LocalDateTime.now().truncatedTo(ChronoUnit.MICROS);
        Assertions.assertThat((LocalDateTime)this.builder.of(localDateTime).getDateTime()).isEqualTo((Object)localDateTime);
        Assertions.assertThat((Object)this.builder.of(localDateTime).get()).isEqualTo((Object)localDateTime);
        LocalDate localDate = LocalDate.now();
        Assertions.assertThat((LocalDate)this.builder.of(localDate).getDate()).isEqualTo((Object)localDate);
        Assertions.assertThat((Object)this.builder.of(localDate).get()).isEqualTo((Object)localDate);
        Assertions.assertThat((Object)this.builder.ofNull().get()).isEqualTo(null);
        Assertions.assertThat((boolean)this.builder.ofNull().isNull()).isTrue();
    }

    @Test
    void testArrayVariant() {
        Instant now = Instant.now().truncatedTo(ChronoUnit.MICROS);
        Variant variant = this.builder.array().add(this.builder.of(1)).add(this.builder.of("hello")).add(this.builder.of(now)).add(this.builder.array().add(this.builder.of("hello2")).add(this.builder.of(10.0f)).build()).add(this.builder.ofNull()).build();
        Assertions.assertThat((boolean)variant.isArray()).isTrue();
        Assertions.assertThat((boolean)variant.isPrimitive()).isFalse();
        Assertions.assertThat((boolean)variant.isObject()).isFalse();
        Assertions.assertThat((Comparable)variant.getType()).isEqualTo((Object)Variant.Type.ARRAY);
        Assertions.assertThat((Object)variant.getElement(-1)).isNull();
        Assertions.assertThat((int)variant.getElement(0).getInt()).isEqualTo(1);
        Assertions.assertThat((String)variant.getElement(1).getString()).isEqualTo("hello");
        Assertions.assertThat((Instant)variant.getElement(2).getInstant()).isEqualTo((Object)now);
        Assertions.assertThat((String)variant.getElement(3).getElement(0).getString()).isEqualTo("hello2");
        Assertions.assertThat((float)variant.getElement(3).getElement(1).getFloat()).isEqualTo(10.0f);
        Assertions.assertThat((boolean)variant.getElement(4).isNull()).isTrue();
        Assertions.assertThat((Object)variant.getElement(5)).isNull();
    }

    @Test
    void testObjectVariant() {
        int i;
        Variant variant = this.builder.object().add("list", this.builder.array().add(this.builder.of("hello")).add(this.builder.of(1)).build()).add("object", this.builder.object().add("ss", this.builder.of((short)1)).add("ff", this.builder.of(10.0f)).build()).add("bb", this.builder.of((byte)10)).build();
        Assertions.assertThat((boolean)variant.isArray()).isFalse();
        Assertions.assertThat((boolean)variant.isPrimitive()).isFalse();
        Assertions.assertThat((boolean)variant.isObject()).isTrue();
        Assertions.assertThat((Comparable)variant.getType()).isEqualTo((Object)Variant.Type.OBJECT);
        Assertions.assertThat((boolean)variant.getField("list").isArray()).isTrue();
        Assertions.assertThat((String)variant.getField("list").getElement(0).getString()).isEqualTo("hello");
        Assertions.assertThat((int)variant.getField("list").getElement(1).getInt()).isEqualTo(1);
        Assertions.assertThat((boolean)variant.getField("object").isObject()).isTrue();
        Assertions.assertThat((short)variant.getField("object").getField("ss").getShort()).isEqualTo((short)1);
        Assertions.assertThat((float)variant.getField("object").getField("ff").getFloat()).isEqualTo(10.0f);
        Assertions.assertThat((byte)variant.getField("bb").getByte()).isEqualTo((byte)10);
        Assertions.assertThat((Object)variant.getField("non_exist")).isNull();
        BinaryVariantBuilder.VariantObjectBuilder objectBuilder = this.builder.object();
        for (i = 0; i < 100; ++i) {
            objectBuilder.add(String.valueOf(i), this.builder.of(i));
        }
        variant = objectBuilder.build();
        for (i = 0; i < 100; ++i) {
            Assertions.assertThat((int)variant.getField(String.valueOf(i)).getInt()).isEqualTo(i);
        }
    }

    @Test
    void testDuplicatedKeyObjectVariant() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.builder.object(false).add("k", this.builder.of((byte)10)).add("k", this.builder.of("hello")).build()).isInstanceOf(RuntimeException.class)).hasMessage("VARIANT_DUPLICATE_KEY");
        Variant variant = this.builder.object(true).add("k", this.builder.of((byte)10)).add("k", this.builder.of("hello")).add("k1", this.builder.of(10)).build();
        Assertions.assertThat((String)variant.getField("k").getString()).isEqualTo("hello");
        Assertions.assertThat((int)variant.getField("k1").getInt()).isEqualTo(10);
    }

    @Test
    void testToJsonScalar() {
        Instant instant = Instant.EPOCH;
        LocalDateTime localDateTime = LocalDateTime.of(2000, 1, 1, 0, 0);
        LocalDate localDate = LocalDate.of(2000, 1, 1);
        Assertions.assertThat((String)this.builder.of((byte)1).toJson()).isEqualTo("1");
        Assertions.assertThat((String)this.builder.of((short)1).toJson()).isEqualTo("1");
        Assertions.assertThat((String)this.builder.of(1L).toJson()).isEqualTo("1");
        Assertions.assertThat((String)this.builder.of(1).toJson()).isEqualTo("1");
        Assertions.assertThat((String)this.builder.of("hello").toJson()).isEqualTo("\"hello\"");
        Assertions.assertThat((String)this.builder.of(true).toJson()).isEqualTo("true");
        Assertions.assertThat((String)this.builder.of(10.0f).toJson()).isEqualTo("10.0");
        Assertions.assertThat((String)this.builder.of(10.0).toJson()).isEqualTo("10.0");
        Assertions.assertThat((String)this.builder.of(BigDecimal.valueOf(100L)).toJson()).isEqualTo("100");
        Assertions.assertThat((String)this.builder.of(instant).toJson()).isEqualTo("\"1970-01-01T00:00:00+00:00\"");
        Assertions.assertThat((String)this.builder.of(localDateTime).toJson()).isEqualTo("\"2000-01-01T00:00:00\"");
        Assertions.assertThat((String)this.builder.of(localDate).toJson()).isEqualTo("\"2000-01-01\"");
        Assertions.assertThat((String)this.builder.of("hello".getBytes()).toJson()).isEqualTo("\"aGVsbG8=\"");
        Assertions.assertThat((String)this.builder.ofNull().toJson()).isEqualTo("null");
    }

    @Test
    void testToJsonNested() {
        Variant variant = this.builder.object().add("list", this.builder.array().add(this.builder.of("hello")).add(this.builder.of(1)).build()).add("object", this.builder.object().add("ss", this.builder.of((short)1)).add("ff", this.builder.of(10.0f)).build()).build();
        String json = variant.toJson();
        Assertions.assertThat((String)json).isEqualTo("{\"list\":[\"hello\",1],\"object\":{\"ff\":10.0,\"ss\":1}}");
    }

    @Test
    void testVariantException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BinaryVariant(new byte[0], new byte[0])).isInstanceOf(RuntimeException.class)).hasMessage("MALFORMED_VARIANT");
        byte[] meta = new byte[]{2};
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BinaryVariant(new byte[1], meta)).isInstanceOf(RuntimeException.class)).hasMessage("MALFORMED_VARIANT");
        byte[] oversize = new byte[0x1000001];
        meta[0] = 1;
        oversize[0] = 1;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BinaryVariant(oversize, meta)).isInstanceOf(RuntimeException.class)).hasMessage("VARIANT_CONSTRUCTOR_SIZE_LIMIT");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new BinaryVariant(new byte[1], oversize)).isInstanceOf(RuntimeException.class)).hasMessage("VARIANT_CONSTRUCTOR_SIZE_LIMIT");
    }

    @Test
    void testGetThrowException() {
        Variant variant = this.builder.of(10.0f);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Variant)variant).getDouble()).isInstanceOf(VariantTypeException.class)).hasMessage("Expected type DOUBLE but got FLOAT");
    }
}

