/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.apache.flink.util.MutableURLClassLoader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FlinkUserCodeClassLoaderTest {
    FlinkUserCodeClassLoaderTest() {
    }

    @Test
    void testExceptionHandling() {
        RuntimeException expectedException = new RuntimeException("Expected exception");
        AtomicReference handledException = new AtomicReference();
        Assertions.assertThatThrownBy(() -> {
            try (ThrowingURLClassLoader classLoaderWithErrorHandler = new ThrowingURLClassLoader(handledException::set, expectedException);){
                classLoaderWithErrorHandler.loadClass("dummy.class");
            }
        }).isSameAs((Object)expectedException);
        Assertions.assertThat((Throwable)((Throwable)handledException.get())).isSameAs((Object)expectedException);
    }

    private static class ThrowingURLClassLoader
    extends FlinkUserCodeClassLoader {
        private final RuntimeException expectedException;

        ThrowingURLClassLoader(Consumer<Throwable> classLoadingExceptionHandler, RuntimeException expectedException) {
            super(new URL[0], null, classLoadingExceptionHandler);
            this.expectedException = expectedException;
        }

        protected Class<?> loadClassWithoutExceptionHandling(String name, boolean resolve) {
            throw this.expectedException;
        }

        public MutableURLClassLoader copy() {
            return new ThrowingURLClassLoader(this.classLoadingExceptionHandler, this.expectedException);
        }
    }
}

