/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.flink.util.IOUtils;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class IOUtilsTest {
    IOUtilsTest() {
    }

    @Test
    void testTryReadFullyFromLongerStream() throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("test-data".getBytes(StandardCharsets.UTF_8));
        byte[] out = new byte[4];
        int read = IOUtils.tryReadFully((InputStream)inputStream, (byte[])out);
        AssertionsForClassTypes.assertThat((byte[])Arrays.copyOfRange(out, 0, read)).containsExactly("test".getBytes(StandardCharsets.UTF_8));
    }

    @Test
    void testTryReadFullyFromShorterStream() throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("t".getBytes(StandardCharsets.UTF_8));
        byte[] out = new byte[4];
        int read = IOUtils.tryReadFully((InputStream)inputStream, (byte[])out);
        AssertionsForClassTypes.assertThat((byte[])Arrays.copyOfRange(out, 0, read)).containsExactly("t".getBytes(StandardCharsets.UTF_8));
    }
}

