/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Random;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleValueSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.StringValue;
import org.apache.flink.types.Value;
import org.apache.flink.util.InstantiationUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class InstantiationUtilTest {
    @TempDir
    private static Path tempFolder;
    private static final String PROXY_DEFINITION_FORMAT = "import java.lang.reflect.InvocationHandler;import java.lang.reflect.Method;import java.io.Serializable;public class %s implements InvocationHandler, Serializable {\n\n  @Override\n  public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {\n    return null;\n  }\n}";

    InstantiationUtilTest() {
    }

    @Test
    void testResolveProxyClass() throws Exception {
        String interfaceName = "UserDefinedInterface";
        String proxyName = "UserProxy";
        try (URLClassLoader userClassLoader = this.createClassLoader("UserDefinedInterface", "UserProxy");){
            Class<?> userInterface = Class.forName("UserDefinedInterface", false, userClassLoader);
            InvocationHandler userProxy = (InvocationHandler)Class.forName("UserProxy", false, userClassLoader).newInstance();
            Object proxy = Proxy.newProxyInstance(userClassLoader, new Class[]{userInterface}, userProxy);
            byte[] serializeObject = InstantiationUtil.serializeObject((Object)proxy);
            Object deserializedProxy = InstantiationUtil.deserializeObject((byte[])serializeObject, (ClassLoader)userClassLoader);
            Assertions.assertThat((Object)deserializedProxy).isNotNull();
        }
    }

    private URLClassLoader createClassLoader(String interfaceName, String proxyName) throws IOException {
        return ClassLoaderUtils.withRoot(TempDirUtils.newFolder((Path)tempFolder)).addClass(interfaceName, String.format("interface %s { void test();}", interfaceName)).addClass(proxyName, this.createProxyDefinition(proxyName)).build();
    }

    private String createProxyDefinition(String proxyName) {
        return String.format(PROXY_DEFINITION_FORMAT, proxyName);
    }

    @Test
    void testInstantiationOfStringValue() {
        Object stringValue = InstantiationUtil.instantiate(StringValue.class, null);
        Assertions.assertThat((Object)stringValue).isNotNull();
    }

    @Test
    void testInstantiationOfStringValueAndCastToValue() {
        Object stringValue = InstantiationUtil.instantiate(StringValue.class, Value.class);
        Assertions.assertThat((Object)stringValue).isNotNull();
    }

    @Test
    void testHasNullaryConstructor() {
        Assertions.assertThat((boolean)InstantiationUtil.hasPublicNullaryConstructor(StringValue.class)).isTrue();
    }

    @Test
    void testHasNullaryConstructorFalse() {
        Assertions.assertThat((boolean)InstantiationUtil.hasPublicNullaryConstructor(InstantiationUtil.class)).isFalse();
    }

    @Test
    void testClassIsProper() {
        Assertions.assertThat((boolean)InstantiationUtil.isProperClass(StringValue.class)).isTrue();
    }

    @Test
    void testClassIsNotProper() {
        Assertions.assertThat((boolean)InstantiationUtil.isProperClass(Value.class)).isFalse();
    }

    @Test
    void testCheckForInstantiationOfPrivateClass() {
        Assertions.assertThatThrownBy(() -> InstantiationUtil.checkForInstantiation(TestClass.class)).isInstanceOf(RuntimeException.class);
    }

    @Test
    void testSerializationToByteArray() throws IOException {
        DoubleValue toSerialize = new DoubleValue(Math.random());
        DoubleValueSerializer serializer = new DoubleValueSerializer();
        byte[] serialized = InstantiationUtil.serializeToByteArray((TypeSerializer)serializer, (Object)toSerialize);
        DoubleValue deserialized = (DoubleValue)InstantiationUtil.deserializeFromByteArray((TypeSerializer)serializer, (byte[])serialized);
        Assertions.assertThat((Comparable)deserialized).isEqualTo((Object)toSerialize);
    }

    @Test
    void testCompressionAndSerializationAlongWithDecompressionAndDeserialization() throws IOException, ClassNotFoundException {
        String value = "teststring";
        Assertions.assertThat((String)((String)InstantiationUtil.decompressAndDeserializeObject((byte[])InstantiationUtil.serializeObjectAndCompress((Object)"teststring"), (ClassLoader)this.getClass().getClassLoader()))).isEqualTo("teststring");
    }

    @Test
    void testWriteToConfigFailingSerialization() throws IOException {
        String key1 = "testkey1";
        String key2 = "testkey2";
        Configuration config = new Configuration();
        Assertions.assertThatThrownBy(() -> InstantiationUtil.writeObjectToConfig((Object)new TestClassWriteFails(), (Configuration)config, (String)"irgnored")).isInstanceOf(TestException.class);
        InstantiationUtil.writeObjectToConfig((Object)new TestClassReadFails(), (Configuration)config, (String)"testkey1");
        InstantiationUtil.writeObjectToConfig((Object)new TestClassReadFailsCNF(), (Configuration)config, (String)"testkey2");
        Assertions.assertThatThrownBy(() -> InstantiationUtil.readObjectFromConfig((Configuration)config, (String)"testkey1", (ClassLoader)this.getClass().getClassLoader())).isInstanceOf(TestException.class);
        Assertions.assertThatThrownBy(() -> InstantiationUtil.readObjectFromConfig((Configuration)config, (String)"testkey2", (ClassLoader)this.getClass().getClassLoader())).isInstanceOf(ClassNotFoundException.class);
    }

    @Test
    void testCopyWritable() throws Exception {
        WritableType original = new WritableType();
        WritableType copy = (WritableType)InstantiationUtil.createCopyWritable((IOReadableWritable)original);
        Assertions.assertThat((Object)copy).isNotSameAs((Object)original);
        Assertions.assertThat((Object)copy).isEqualTo((Object)original);
    }

    public static final class WritableType
    implements IOReadableWritable {
        private int aInt;
        private long aLong;

        public WritableType() {
            Random rnd = new Random();
            this.aInt = rnd.nextInt();
            this.aLong = rnd.nextLong();
        }

        public int hashCode() {
            return Objects.hash(this.aInt, this.aLong);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == WritableType.class) {
                WritableType that = (WritableType)obj;
                return this.aLong == that.aLong && this.aInt == that.aInt;
            }
            return false;
        }

        public void write(DataOutputView out) throws IOException {
            out.writeInt(this.aInt);
            out.writeLong(this.aLong);
        }

        public void read(DataInputView in) throws IOException {
            this.aInt = in.readInt();
            this.aLong = in.readLong();
        }
    }

    private static class TestClassReadFailsCNF
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private TestClassReadFailsCNF() {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new ClassNotFoundException("test exception");
        }
    }

    private static class TestClassReadFails
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private TestClassReadFails() {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new TestException();
        }
    }

    private static class TestClassWriteFails
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private TestClassWriteFails() {
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            throw new TestException();
        }
    }

    private static class TestException
    extends IOException {
        private static final long serialVersionUID = 1L;

        private TestException() {
        }
    }

    private class TestClass {
        private TestClass() {
        }
    }
}

