/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.util.LinkedOptionalMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class LinkedOptionalMapTest {
    LinkedOptionalMapTest() {
    }

    @Test
    void usageExample() {
        LinkedOptionalMap map = new LinkedOptionalMap();
        map.put("java.lang.String", String.class, (Object)"a string class");
        map.put("scala.Option", null, (Object)"a scala Option");
        map.put("java.lang.Boolean", Boolean.class, null);
        Assertions.assertThat((Collection)map.keyNames()).contains((Object[])new String[]{"java.lang.String", "scala.Option"});
        Assertions.assertThat((Collection)map.absentKeysOrValues()).contains((Object[])new String[]{"scala.Option", "java.lang.Boolean"});
    }

    @Test
    void overridingKeyWithTheSameKeyName() {
        LinkedOptionalMap map = new LinkedOptionalMap();
        map.put("java.lang.String", null, (Object)"a string class");
        map.put("java.lang.String", String.class, (Object)"a string class");
        Assertions.assertThat((Collection)map.absentKeysOrValues()).isEmpty();
    }

    @Test
    void overridingKeysAndValuesWithTheSameKeyName() {
        LinkedOptionalMap map = new LinkedOptionalMap();
        map.put("java.lang.String", null, null);
        map.put("java.lang.String", String.class, (Object)"a string class");
        Assertions.assertThat((Collection)map.absentKeysOrValues()).isEmpty();
    }

    @Test
    void overridingAValueWithMissingKeyShouldBeConsideredAsAbsent() {
        LinkedOptionalMap map = new LinkedOptionalMap();
        map.put("java.lang.String", null, null);
        map.put("java.lang.String", null, (Object)"a string class");
        Assertions.assertThat((Collection)map.absentKeysOrValues()).contains((Object[])new String[]{"java.lang.String"});
    }

    @Test
    void mergingMapsWithPresentEntriesLeavesNoAbsentKeyNames() {
        LinkedOptionalMap first = new LinkedOptionalMap();
        first.put("b", null, null);
        first.put("c", String.class, null);
        LinkedOptionalMap second = new LinkedOptionalMap();
        second.put("a", String.class, (Object)"aaa");
        second.put("b", String.class, (Object)"bbb");
        second.put("c", Void.class, (Object)"ccc");
        second.put("d", String.class, (Object)"ddd");
        first.putAll(second);
        Assertions.assertThat((Collection)first.absentKeysOrValues()).isEmpty();
    }

    @Test
    void mergingMapsPreserversTheOrderOfTheOriginalMap() {
        LinkedOptionalMap first = new LinkedOptionalMap();
        first.put("b", null, null);
        first.put("c", String.class, null);
        LinkedOptionalMap second = new LinkedOptionalMap();
        second.put("a", String.class, (Object)"aaa");
        second.put("b", String.class, (Object)"bbb");
        second.put("c", Void.class, (Object)"ccc");
        second.put("d", String.class, (Object)"ddd");
        first.putAll(second);
        Assertions.assertThat((Collection)first.keyNames()).contains((Object[])new String[]{"b", "c", "a", "d"});
    }

    @Test
    void mergingToEmpty() {
        LinkedOptionalMap first = new LinkedOptionalMap();
        LinkedOptionalMap second = new LinkedOptionalMap();
        second.put("a", String.class, (Object)"aaa");
        second.put("b", String.class, (Object)"bbb");
        second.put("c", Void.class, (Object)"ccc");
        second.put("d", String.class, (Object)"ddd");
        first.putAll(second);
        Assertions.assertThat((Collection)first.keyNames()).contains((Object[])new String[]{"a", "b", "c", "d"});
    }

    @Test
    void unwrapOptionalsWithMissingValueThrows() {
        Assertions.assertThatThrownBy(() -> {
            LinkedOptionalMap map = new LinkedOptionalMap();
            map.put("a", String.class, null);
            map.unwrapOptionals();
        }).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void unwrapOptionalsWithMissingKeyThrows() {
        Assertions.assertThatThrownBy(() -> {
            LinkedOptionalMap map = new LinkedOptionalMap();
            map.put("a", null, (Object)"blabla");
            map.unwrapOptionals();
        }).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void unwrapOptionalsPreservesOrder() {
        LinkedOptionalMap map = new LinkedOptionalMap();
        map.put("a", String.class, (Object)"aaa");
        map.put("b", Boolean.class, (Object)"bbb");
        LinkedHashMap m = map.unwrapOptionals();
        Assertions.assertThat((Map)m).containsKeys((Object[])new Class[]{String.class, Boolean.class});
        Assertions.assertThat((Map)m).containsValues((Object[])new String[]{"aaa", "bbb"});
    }

    @Test
    void testPrefix() {
        LinkedOptionalMap left = new LinkedOptionalMap();
        left.put("a", String.class, (Object)"aaa");
        left.put("b", String.class, (Object)"aaa");
        LinkedOptionalMap right = new LinkedOptionalMap(left);
        right.put("c", Boolean.class, (Object)"bbb");
        Assertions.assertThat((boolean)LinkedOptionalMap.isLeftPrefixOfRight((LinkedOptionalMap)left, (LinkedOptionalMap)right)).isTrue();
    }

    @Test
    void testNonPrefix() {
        LinkedOptionalMap left = new LinkedOptionalMap();
        left.put("a", String.class, (Object)"aaa");
        left.put("c", String.class, (Object)"aaa");
        LinkedOptionalMap right = new LinkedOptionalMap();
        right.put("b", Boolean.class, (Object)"bbb");
        right.put("c", Boolean.class, (Object)"bbb");
        Assertions.assertThat((boolean)LinkedOptionalMap.isLeftPrefixOfRight((LinkedOptionalMap)left, (LinkedOptionalMap)right)).isFalse();
    }

    @Test
    void demoMergeResult() {
        LinkedOptionalMap left = new LinkedOptionalMap();
        left.put("b", null, null);
        left.put("c", String.class, null);
        LinkedOptionalMap right = new LinkedOptionalMap();
        right.put("b", String.class, (Object)"bbb");
        right.put("c", Void.class, (Object)"ccc");
        right.put("a", Boolean.class, (Object)"aaa");
        right.put("d", Long.class, (Object)"ddd");
        LinkedOptionalMap.MergeResult result = LinkedOptionalMap.mergeRightIntoLeft((LinkedOptionalMap)left, (LinkedOptionalMap)right);
        Assertions.assertThat((boolean)result.hasMissingKeys()).isFalse();
        Assertions.assertThat((boolean)result.isOrderedSubset()).isTrue();
        Assertions.assertThat((Collection)result.missingKeys()).isEmpty();
        LinkedHashMap merged = result.getMerged();
        Assertions.assertThat(merged.keySet()).containsExactly((Object[])new Class[]{String.class, Void.class, Boolean.class, Long.class});
    }
}

