/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.util.TernaryBoolean;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TernaryBooleanTest {
    TernaryBooleanTest() {
    }

    @Test
    void testWithDefault() {
        Assertions.assertThat((boolean)TernaryBoolean.TRUE.getOrDefault(true)).isTrue();
        Assertions.assertThat((boolean)TernaryBoolean.TRUE.getOrDefault(false)).isTrue();
        Assertions.assertThat((boolean)TernaryBoolean.FALSE.getOrDefault(true)).isFalse();
        Assertions.assertThat((boolean)TernaryBoolean.FALSE.getOrDefault(false)).isFalse();
        Assertions.assertThat((boolean)TernaryBoolean.UNDEFINED.getOrDefault(true)).isTrue();
        Assertions.assertThat((boolean)TernaryBoolean.UNDEFINED.getOrDefault(false)).isFalse();
    }

    @Test
    void testResolveUndefined() {
        Assertions.assertThat((Comparable)TernaryBoolean.TRUE.resolveUndefined(true)).isEqualTo((Object)TernaryBoolean.TRUE);
        Assertions.assertThat((Comparable)TernaryBoolean.TRUE.resolveUndefined(false)).isEqualTo((Object)TernaryBoolean.TRUE);
        Assertions.assertThat((Comparable)TernaryBoolean.FALSE.resolveUndefined(true)).isEqualTo((Object)TernaryBoolean.FALSE);
        Assertions.assertThat((Comparable)TernaryBoolean.FALSE.resolveUndefined(false)).isEqualTo((Object)TernaryBoolean.FALSE);
        Assertions.assertThat((Comparable)TernaryBoolean.UNDEFINED.resolveUndefined(true)).isEqualTo((Object)TernaryBoolean.TRUE);
        Assertions.assertThat((Comparable)TernaryBoolean.UNDEFINED.resolveUndefined(false)).isEqualTo((Object)TernaryBoolean.FALSE);
    }

    @Test
    void testToBoolean() {
        Assertions.assertThat((Boolean)TernaryBoolean.TRUE.getAsBoolean()).isSameAs((Object)Boolean.TRUE);
        Assertions.assertThat((Boolean)TernaryBoolean.FALSE.getAsBoolean()).isSameAs((Object)Boolean.FALSE);
        Assertions.assertThat((Boolean)TernaryBoolean.UNDEFINED.getAsBoolean()).isNull();
    }

    @Test
    void testFromBoolean() {
        Assertions.assertThat((Comparable)TernaryBoolean.fromBoolean((boolean)true)).isEqualTo((Object)TernaryBoolean.TRUE);
        Assertions.assertThat((Comparable)TernaryBoolean.fromBoolean((boolean)false)).isEqualTo((Object)TernaryBoolean.FALSE);
    }

    @Test
    void testFromBoxedBoolean() {
        Assertions.assertThat((Comparable)TernaryBoolean.fromBoxedBoolean((Boolean)Boolean.TRUE)).isEqualTo((Object)TernaryBoolean.TRUE);
        Assertions.assertThat((Comparable)TernaryBoolean.fromBoxedBoolean((Boolean)Boolean.FALSE)).isEqualTo((Object)TernaryBoolean.FALSE);
        Assertions.assertThat((Comparable)TernaryBoolean.fromBoxedBoolean(null)).isEqualTo((Object)TernaryBoolean.UNDEFINED);
    }
}

