/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.util.concurrent.DirectExecutorService;
import org.apache.flink.util.function.ThrowingConsumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DirectExecutorServiceTest {
    DirectExecutorServiceTest() {
    }

    @Test
    void testExecute() {
        CompletableFuture future = new CompletableFuture();
        this.testTaskSubmissionBeforeShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.execute(() -> future.complete(Thread.currentThread()))));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testSubmitRunnable() {
        CompletableFuture future = new CompletableFuture();
        this.testTaskSubmissionBeforeShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.submit(() -> future.complete(Thread.currentThread()))));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testSubmitCallable() {
        CompletableFuture future = new CompletableFuture();
        this.testTaskSubmissionBeforeShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.submit(DirectExecutorServiceTest.callableFromFuture(future))));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testSubmitRunnableWithResult() {
        CompletableFuture future = new CompletableFuture();
        this.testTaskSubmissionBeforeShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.submit(() -> future.complete(Thread.currentThread()), null)));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testInvokeAll() {
        CompletableFuture future = new CompletableFuture();
        this.testTaskSubmissionBeforeShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAll(DirectExecutorServiceTest.callableCollectionFromFuture(future))));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testInvokeAllWithTimeout() {
        CompletableFuture future = new CompletableFuture();
        this.testTaskSubmissionBeforeShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAll(DirectExecutorServiceTest.callableCollectionFromFuture(future), 1L, TimeUnit.DAYS)));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testInvokeAny() {
        CompletableFuture future = new CompletableFuture();
        this.testTaskSubmissionBeforeShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAny(DirectExecutorServiceTest.callableCollectionFromFuture(future))));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testInvokeAnyWithTimeout() {
        CompletableFuture future = new CompletableFuture();
        this.testTaskSubmissionBeforeShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAny(DirectExecutorServiceTest.callableCollectionFromFuture(future), 1L, TimeUnit.DAYS)));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    private void testTaskSubmissionBeforeShutdown(ThrowingConsumer<ExecutorService, Throwable> taskSubmission) {
        DirectExecutorService testInstance = new DirectExecutorService(true);
        this.testSuccessfulTaskSubmission((ExecutorService)testInstance, taskSubmission);
        testInstance.shutdown();
    }

    @Test
    void testExecuteWithNoopShutdown() {
        CompletableFuture future = new CompletableFuture();
        this.testWithNoopShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.execute(() -> future.complete(Thread.currentThread()))));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testSubmitRunnableWithNoopShutdown() {
        CompletableFuture future = new CompletableFuture();
        this.testWithNoopShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.submit(() -> future.complete(Thread.currentThread()))));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testSubmitCallableWithNoopShutdown() {
        CompletableFuture future = new CompletableFuture();
        this.testWithNoopShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.submit(DirectExecutorServiceTest.callableFromFuture(future))));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testSubmitRunnableWithResultAndNoopShutdown() {
        CompletableFuture future = new CompletableFuture();
        this.testWithNoopShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.submit(() -> future.complete(Thread.currentThread()), null)));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testInvokeAllWithNoopShutdown() {
        CompletableFuture future = new CompletableFuture();
        this.testWithNoopShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAll(DirectExecutorServiceTest.callableCollectionFromFuture(future))));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testInvokeAllWithTimeoutAndNoopShutdown() {
        CompletableFuture future = new CompletableFuture();
        this.testWithNoopShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAll(DirectExecutorServiceTest.callableCollectionFromFuture(future), 1L, TimeUnit.DAYS)));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testInvokeAnyWithNoopShutdown() {
        CompletableFuture future = new CompletableFuture();
        this.testWithNoopShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAny(DirectExecutorServiceTest.callableCollectionFromFuture(future))));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    @Test
    void testInvokeAnyWithTimeoutAndNoopShutdown() {
        CompletableFuture future = new CompletableFuture();
        this.testWithNoopShutdown((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAny(DirectExecutorServiceTest.callableCollectionFromFuture(future), 1L, TimeUnit.DAYS)));
        Assertions.assertThat(future).isCompletedWithValue((Object)Thread.currentThread());
    }

    private void testWithNoopShutdown(ThrowingConsumer<ExecutorService, Throwable> taskSubmission) {
        DirectExecutorService testInstance = new DirectExecutorService(false);
        testInstance.shutdown();
        this.testSuccessfulTaskSubmission((ExecutorService)testInstance, taskSubmission);
    }

    private static List<Callable<Void>> callableCollectionFromFuture(CompletableFuture<Thread> future) {
        return Collections.singletonList(DirectExecutorServiceTest.callableFromFuture(future));
    }

    private static Callable<Void> callableFromFuture(CompletableFuture<Thread> future) {
        return () -> {
            future.complete(Thread.currentThread());
            return null;
        };
    }

    private void testSuccessfulTaskSubmission(ExecutorService testInstance, ThrowingConsumer<ExecutorService, Throwable> taskSubmission) {
        Assertions.assertThatNoException().isThrownBy(() -> taskSubmission.accept((Object)testInstance));
    }

    @Test
    void testRejectedExecute() {
        this.testRejectedExecutionException((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.execute(() -> {})));
    }

    @Test
    void testRejectedSubmitRunnable() {
        this.testRejectedExecutionException((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.submit(() -> {})));
    }

    @Test
    void testRejectedSubmitCallable() {
        this.testRejectedExecutionException((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.submit(() -> null)));
    }

    @Test
    void testRejectedSubmitWithResult() {
        this.testRejectedExecutionException((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.submit(() -> {}, null)));
    }

    @Test
    void testRejectedInvokeAll() {
        this.testRejectedExecutionException((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAll(Collections.singleton(() -> null))));
    }

    @Test
    void testRejectedInvokeAllWithEmptyList() {
        this.testRejectedExecutionException((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAll(Collections.emptyList())));
    }

    @Test
    void testRejectedInvokeAllWithTimeout() {
        this.testRejectedExecutionException((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAll(Collections.singleton(() -> null), 1L, TimeUnit.DAYS)));
    }

    @Test
    void testRejectedInvokeAllWithEmptyListAndTimeout() {
        this.testRejectedExecutionException((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAll(Collections.emptyList(), 1L, TimeUnit.DAYS)));
    }

    @Test
    void testRejectedInvokeAny() {
        this.testRejectedExecutionException((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAny(Collections.singleton(() -> null))));
    }

    @Test
    void testRejectedInvokeAnyWithEmptyList() {
        this.testRejectedExecutionException((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAny(Collections.emptyList())));
    }

    @Test
    void testRejectedInvokeAnyWithTimeout() {
        this.testRejectedExecutionException((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAll(Collections.singleton(() -> null), 1L, TimeUnit.DAYS)));
    }

    @Test
    void testRejectedInvokeAnyWithEmptyListAndTimeout() {
        this.testRejectedExecutionException((ThrowingConsumer<ExecutorService, Throwable>)((ThrowingConsumer)testInstance -> testInstance.invokeAll(Collections.emptyList(), 1L, TimeUnit.DAYS)));
    }

    private void testRejectedExecutionException(ThrowingConsumer<ExecutorService, Throwable> taskSubmission) {
        DirectExecutorService testInstance = new DirectExecutorService(true);
        testInstance.shutdown();
        Assertions.assertThatThrownBy(() -> DirectExecutorServiceTest.lambda$testRejectedExecutionException$44(taskSubmission, (ExecutorService)testInstance)).isInstanceOf(RejectedExecutionException.class);
    }

    private static /* synthetic */ void lambda$testRejectedExecutionException$44(ThrowingConsumer taskSubmission, ExecutorService testInstance) throws Throwable {
        taskSubmission.accept((Object)testInstance);
    }
}

