/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;

@PublicEvolving
public class DoubleMaximum
implements SimpleAccumulator<Double> {
    private static final long serialVersionUID = 1L;
    private double max = Double.NEGATIVE_INFINITY;

    public DoubleMaximum() {
    }

    public DoubleMaximum(double value) {
        this.max = value;
    }

    @Override
    public void add(Double value) {
        this.max = Math.max(this.max, value);
    }

    @Override
    public Double getLocalValue() {
        return this.max;
    }

    @Override
    public void merge(Accumulator<Double, Double> other) {
        this.max = Math.max(this.max, other.getLocalValue());
    }

    @Override
    public void resetLocal() {
        this.max = Double.NEGATIVE_INFINITY;
    }

    public DoubleMaximum clone() {
        return new DoubleMaximum(this.max);
    }

    @Override
    public void add(double value) {
        this.max = Math.max(this.max, value);
    }

    public double getLocalValuePrimitive() {
        return this.max;
    }

    public String toString() {
        return "DoubleMaximum " + this.max;
    }
}

