/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state.v2;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.SerializerFactory;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.v2.StateSerializerReference;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@Experimental
public abstract class StateDescriptor<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final String stateId;
    @Nonnull
    private final StateSerializerReference<T> typeSerializer;
    @Nonnull
    private StateTtlConfig ttlConfig = StateTtlConfig.DISABLED;

    protected StateDescriptor(@Nonnull String stateId, @Nonnull TypeInformation<T> typeInfo) {
        this.stateId = Preconditions.checkNotNull(stateId, "state id must not be null");
        this.typeSerializer = new StateSerializerReference<T>(typeInfo);
    }

    protected StateDescriptor(@Nonnull String stateId, TypeSerializer<T> serializer) {
        this.stateId = Preconditions.checkNotNull(stateId, "stateId must not be null");
        this.typeSerializer = new StateSerializerReference<T>(serializer);
    }

    protected StateDescriptor(String name, Class<T> type) {
        this.stateId = Preconditions.checkNotNull(name, "name must not be null");
        Preconditions.checkNotNull(type, "type class must not be null");
        this.typeSerializer = new StateSerializerReference<T>(type);
    }

    public void enableTimeToLive(StateTtlConfig ttlConfig) {
        this.ttlConfig = Preconditions.checkNotNull(ttlConfig);
    }

    @Nonnull
    public StateTtlConfig getTtlConfig() {
        return this.ttlConfig;
    }

    @Nonnull
    public String getStateId() {
        return this.stateId;
    }

    @Nonnull
    public TypeSerializer<T> getSerializer() {
        TypeSerializer serializer = (TypeSerializer)this.typeSerializer.get();
        if (serializer != null) {
            return serializer.duplicate();
        }
        throw new IllegalStateException("Serializer not yet initialized.");
    }

    @Internal
    @Nullable
    public TypeInformation<T> getTypeInformation() {
        return this.typeSerializer.getTypeInformation();
    }

    public boolean isSerializerInitialized() {
        return this.typeSerializer.isInitialized();
    }

    public void initializeSerializerUnlessSet(ExecutionConfig executionConfig) {
        this.typeSerializer.initializeUnlessSet(executionConfig);
    }

    @Internal
    public void initializeSerializerUnlessSet(SerializerFactory serializerFactory) {
        this.typeSerializer.initializeUnlessSet(serializerFactory);
    }

    public int hashCode() {
        return this.stateId.hashCode() + 31 * this.getClass().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o.getClass() == this.getClass()) {
            StateDescriptor that = (StateDescriptor)o;
            return this.stateId.equals(that.stateId);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{stateId=" + this.stateId + ", typeSerializer=" + this.typeSerializer + ", ttlConfig=" + this.ttlConfig + "}";
    }

    @Internal
    public abstract Type getType();

    @Internal
    public static enum Type {
        VALUE,
        LIST,
        REDUCING,
        AGGREGATING,
        MAP;

    }
}

