/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeinfo;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.StringArraySerializer;
import org.apache.flink.util.Preconditions;

@Public
public final class BasicArrayTypeInfo<T, C>
extends TypeInformation<T> {
    private static final long serialVersionUID = 1L;
    public static final BasicArrayTypeInfo<String[], String> STRING_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<String[], String>(String[].class, BasicTypeInfo.STRING_TYPE_INFO);
    public static final BasicArrayTypeInfo<Boolean[], Boolean> BOOLEAN_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Boolean[], Boolean>(Boolean[].class, BasicTypeInfo.BOOLEAN_TYPE_INFO);
    public static final BasicArrayTypeInfo<Byte[], Byte> BYTE_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Byte[], Byte>(Byte[].class, BasicTypeInfo.BYTE_TYPE_INFO);
    public static final BasicArrayTypeInfo<Short[], Short> SHORT_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Short[], Short>(Short[].class, BasicTypeInfo.SHORT_TYPE_INFO);
    public static final BasicArrayTypeInfo<Integer[], Integer> INT_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Integer[], Integer>(Integer[].class, BasicTypeInfo.INT_TYPE_INFO);
    public static final BasicArrayTypeInfo<Long[], Long> LONG_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Long[], Long>(Long[].class, BasicTypeInfo.LONG_TYPE_INFO);
    public static final BasicArrayTypeInfo<Float[], Float> FLOAT_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Float[], Float>(Float[].class, BasicTypeInfo.FLOAT_TYPE_INFO);
    public static final BasicArrayTypeInfo<Double[], Double> DOUBLE_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Double[], Double>(Double[].class, BasicTypeInfo.DOUBLE_TYPE_INFO);
    public static final BasicArrayTypeInfo<Character[], Character> CHAR_ARRAY_TYPE_INFO = new BasicArrayTypeInfo<Character[], Character>(Character[].class, BasicTypeInfo.CHAR_TYPE_INFO);
    private final Class<T> arrayClass;
    private final TypeInformation<C> componentInfo;
    private static final Map<Class<?>, BasicArrayTypeInfo<?, ?>> TYPES = new HashMap();

    private BasicArrayTypeInfo(Class<T> arrayClass, BasicTypeInfo<C> componentInfo) {
        this.arrayClass = Preconditions.checkNotNull(arrayClass);
        this.componentInfo = Preconditions.checkNotNull(componentInfo);
    }

    @Override
    @PublicEvolving
    public boolean isBasicType() {
        return false;
    }

    @Override
    @PublicEvolving
    public boolean isTupleType() {
        return false;
    }

    @Override
    @PublicEvolving
    public int getArity() {
        return 1;
    }

    @Override
    @PublicEvolving
    public int getTotalFields() {
        return 1;
    }

    @Override
    @PublicEvolving
    public Class<T> getTypeClass() {
        return this.arrayClass;
    }

    @PublicEvolving
    public Class<C> getComponentTypeClass() {
        return this.componentInfo.getTypeClass();
    }

    @PublicEvolving
    public TypeInformation<C> getComponentInfo() {
        return this.componentInfo;
    }

    @Override
    @PublicEvolving
    public boolean isKeyType() {
        return false;
    }

    @Override
    @PublicEvolving
    public TypeSerializer<T> createSerializer(SerializerConfig serializerConfig) {
        if (this.componentInfo.getTypeClass().equals(String.class)) {
            return StringArraySerializer.INSTANCE;
        }
        return new GenericArraySerializer<C>(this.componentInfo.getTypeClass(), this.componentInfo.createSerializer(serializerConfig));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BasicArrayTypeInfo) {
            BasicArrayTypeInfo other = (BasicArrayTypeInfo)obj;
            return other.canEqual(this) && this.arrayClass == other.arrayClass && this.componentInfo.equals(other.componentInfo);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arrayClass, this.componentInfo);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BasicArrayTypeInfo;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.componentInfo + ">";
    }

    @PublicEvolving
    public static <X, C> BasicArrayTypeInfo<X, C> getInfoFor(Class<X> type) {
        if (!type.isArray()) {
            throw new InvalidTypesException("The given class is no array.");
        }
        return TYPES.get(type);
    }

    static {
        TYPES.put(String[].class, STRING_ARRAY_TYPE_INFO);
        TYPES.put(Boolean[].class, BOOLEAN_ARRAY_TYPE_INFO);
        TYPES.put(Byte[].class, BYTE_ARRAY_TYPE_INFO);
        TYPES.put(Short[].class, SHORT_ARRAY_TYPE_INFO);
        TYPES.put(Integer[].class, INT_ARRAY_TYPE_INFO);
        TYPES.put(Long[].class, LONG_ARRAY_TYPE_INFO);
        TYPES.put(Float[].class, FLOAT_ARRAY_TYPE_INFO);
        TYPES.put(Double[].class, DOUBLE_ARRAY_TYPE_INFO);
        TYPES.put(Character[].class, CHAR_ARRAY_TYPE_INFO);
    }
}

