/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.operators;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.datastream.api.context.PartitionedContext;
import org.apache.flink.datastream.api.context.ProcessingTimeManager;
import org.apache.flink.datastream.api.function.TwoInputNonBroadcastStreamProcessFunction;
import org.apache.flink.datastream.impl.context.DefaultProcessingTimeManager;
import org.apache.flink.datastream.impl.extension.eventtime.functions.EventTimeWrappedTwoInputNonBroadcastStreamProcessFunction;
import org.apache.flink.datastream.impl.operators.BaseKeyedTwoInputNonBroadcastProcessOperator;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.Triggerable;

public class KeyedTwoInputNonBroadcastProcessOperator<KEY, IN1, IN2, OUT>
extends BaseKeyedTwoInputNonBroadcastProcessOperator<KEY, IN1, IN2, OUT>
implements Triggerable<KEY, VoidNamespace> {
    private transient InternalTimerService<VoidNamespace> timerService;

    public KeyedTwoInputNonBroadcastProcessOperator(TwoInputNonBroadcastStreamProcessFunction<IN1, IN2, OUT> userFunction) {
        this(userFunction, null);
    }

    public KeyedTwoInputNonBroadcastProcessOperator(TwoInputNonBroadcastStreamProcessFunction<IN1, IN2, OUT> userFunction, @Nullable KeySelector<OUT, KEY> outKeySelector) {
        super(userFunction, outKeySelector);
    }

    @Override
    public void open() throws Exception {
        this.timerService = this.getInternalTimerService("processing timer", (TypeSerializer)VoidNamespaceSerializer.INSTANCE, this);
        super.open();
    }

    @Override
    protected ProcessingTimeManager getProcessingTimeManager() {
        return new DefaultProcessingTimeManager(this.timerService);
    }

    public void onEventTime(InternalTimer<KEY, VoidNamespace> timer) throws Exception {
        if (this.userFunction instanceof EventTimeWrappedTwoInputNonBroadcastStreamProcessFunction) {
            ((EventTimeWrappedTwoInputNonBroadcastStreamProcessFunction)this.userFunction).onEventTime(timer.getTimestamp(), this.getOutputCollector(), this.partitionedContext);
        }
    }

    public void onProcessingTime(InternalTimer<KEY, VoidNamespace> timer) throws Exception {
        ((TwoInputNonBroadcastStreamProcessFunction)this.userFunction).onProcessingTimer(timer.getTimestamp(), this.getOutputCollector(), (PartitionedContext)this.partitionedContext);
    }

    @Override
    protected InternalTimerService<VoidNamespace> getTimerService() {
        return this.timerService;
    }

    @Override
    protected Supplier<Long> getEventTimeSupplier() {
        return () -> this.timerService.currentWatermark();
    }
}

