/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.stats.stackdriver;

import com.google.api.MonitoredResource;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeSeries;
import io.opencensus.exporter.metrics.util.MetricExporter;
import io.opencensus.exporter.stats.stackdriver.StackdriverExportUtils;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.export.Metric;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class CreateTimeSeriesExporter
extends MetricExporter {
    private static final Tracer tracer = Tracing.getTracer();
    private static final Logger logger = Logger.getLogger(CreateTimeSeriesExporter.class.getName());
    private final ProjectName projectName;
    private final MetricServiceClient metricServiceClient;
    private final MonitoredResource monitoredResource;
    private final String domain;
    private final Map<LabelKey, LabelValue> constantLabels;

    CreateTimeSeriesExporter(String projectId, MetricServiceClient metricServiceClient, MonitoredResource monitoredResource, @Nullable String metricNamePrefix, Map<LabelKey, LabelValue> constantLabels) {
        this.projectName = ProjectName.newBuilder().setProject(projectId).build();
        this.metricServiceClient = metricServiceClient;
        this.monitoredResource = monitoredResource;
        this.domain = StackdriverExportUtils.getDomain(metricNamePrefix);
        this.constantLabels = constantLabels;
    }

    @Override
    public void export(Collection<Metric> metrics) {
        ArrayList<TimeSeries> timeSeriesList = new ArrayList<TimeSeries>(metrics.size());
        for (Metric metric : metrics) {
            timeSeriesList.addAll(StackdriverExportUtils.createTimeSeriesList(metric, this.monitoredResource, this.domain, this.projectName.getProject(), this.constantLabels));
        }
        Span span = tracer.getCurrentSpan();
        for (List batchedTimeSeries : Lists.partition(timeSeriesList, 200)) {
            span.addAnnotation("Export Stackdriver TimeSeries.");
            try {
                CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setName(this.projectName.toString()).addAllTimeSeries(batchedTimeSeries).build();
                this.metricServiceClient.createTimeSeries(request);
                span.addAnnotation("Finish exporting TimeSeries.");
            }
            catch (ApiException e) {
                logger.log(Level.WARNING, "ApiException thrown when exporting TimeSeries.", e);
                span.setStatus(Status.CanonicalCode.valueOf(e.getStatusCode().getCode().name()).toStatus().withDescription("ApiException thrown when exporting TimeSeries: " + StackdriverExportUtils.exceptionMessage(e)));
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Exception thrown when exporting TimeSeries.", e);
                span.setStatus(Status.UNKNOWN.withDescription("Exception thrown when exporting TimeSeries: " + StackdriverExportUtils.exceptionMessage(e)));
            }
        }
    }
}

