/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.sca;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.sca.ModifiedASMFrame;
import org.apache.flink.shaded.org.objectweb.asm.Type;
import org.apache.flink.shaded.org.objectweb.asm.tree.analysis.BasicValue;

@Internal
public class TaggedValue
extends BasicValue {
    private Tag tag;
    private boolean callByValue = false;
    private Input input;
    private String flatFieldExpr;
    private boolean grouped;
    private Map<String, TaggedValue> containerMapping;
    private Map<String, ModifiedASMFrame> containerFrameMapping;
    private int intConstant;

    public TaggedValue(Type type) {
        this(type, Tag.REGULAR);
    }

    public TaggedValue(Type type, Tag tag) {
        super(type);
        this.tag = tag;
    }

    public TaggedValue(Type type, Input input, String flatFieldExpr, boolean grouped, boolean callByValue) {
        super(type);
        this.tag = Tag.INPUT;
        this.input = input;
        this.flatFieldExpr = flatFieldExpr;
        this.grouped = grouped;
        this.callByValue = callByValue;
    }

    public TaggedValue(Type type, Map<String, TaggedValue> containerMapping) {
        super(type);
        this.tag = Tag.CONTAINER;
        this.containerMapping = containerMapping;
    }

    public TaggedValue(int constant) {
        super(Type.INT_TYPE);
        this.tag = Tag.INT_CONSTANT;
        this.intConstant = constant;
    }

    public boolean isInput() {
        return this.tag == Tag.INPUT;
    }

    public boolean isThis() {
        return this.tag == Tag.THIS;
    }

    public boolean isContainer() {
        return this.tag == Tag.CONTAINER;
    }

    public boolean isRegular() {
        return this.tag == Tag.REGULAR;
    }

    public boolean isIntConstant() {
        return this.tag == Tag.INT_CONSTANT;
    }

    public boolean isCollector() {
        return this.tag == Tag.COLLECTOR;
    }

    public boolean isInputIterable() {
        return this.tag == Tag.INPUT_1_ITERABLE || this.tag == Tag.INPUT_2_ITERABLE;
    }

    public boolean isInputIterator() {
        return this.tag == Tag.INPUT_1_ITERATOR || this.tag == Tag.INPUT_2_ITERATOR;
    }

    public boolean isInput1Iterable() {
        return this.tag == Tag.INPUT_1_ITERABLE;
    }

    public boolean isInput1Iterator() {
        return this.tag == Tag.INPUT_1_ITERATOR;
    }

    public boolean isIteratorTrueAssumption() {
        return this.tag == Tag.ITERATOR_TRUE_ASSUMPTION;
    }

    public boolean isNull() {
        return this.tag == Tag.NULL;
    }

    public boolean canNotContainInput() {
        return this.tag != Tag.INPUT && this.tag != Tag.CONTAINER && this.tag != Tag.THIS;
    }

    public boolean canContainInput() {
        return this.tag == Tag.INPUT || this.tag == Tag.CONTAINER || this.tag == Tag.THIS;
    }

    public boolean canContainFields() {
        return this.tag == Tag.CONTAINER || this.tag == Tag.THIS;
    }

    public boolean isCallByValue() {
        return this.callByValue;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
        if (tag == Tag.CONTAINER || tag == Tag.THIS) {
            this.input = null;
            this.flatFieldExpr = null;
        } else if (tag == Tag.INPUT) {
            this.containerMapping = null;
        } else {
            this.input = null;
            this.containerMapping = null;
            this.flatFieldExpr = null;
        }
    }

    public String toForwardedFieldsExpression(Input input) {
        if (this.isInput() && this.input != input) {
            return null;
        }
        if (this.isInput() && this.flatFieldExpr.length() == 0) {
            return "*";
        }
        if (this.isInput()) {
            return this.flatFieldExpr + "->*";
        }
        if (this.canContainFields() && this.containerMapping != null) {
            StringBuilder sb = new StringBuilder();
            this.traverseContainer(input, this.containerMapping, sb, "");
            String returnValue = sb.toString();
            if (returnValue != null && returnValue.length() > 0) {
                return returnValue;
            }
        }
        return null;
    }

    private void traverseContainer(Input input, Map<String, TaggedValue> containerMapping, StringBuilder sb, String prefix) {
        for (Map.Entry<String, TaggedValue> entry : containerMapping.entrySet()) {
            if (entry.getValue() == null) continue;
            if (entry.getValue().isInput() && entry.getValue().input == input) {
                String flatFieldExpr = entry.getValue().getFlatFieldExpr();
                if (flatFieldExpr.length() == 0) {
                    sb.append("*");
                } else {
                    sb.append(flatFieldExpr);
                }
                sb.append("->");
                if (prefix.length() > 0) {
                    sb.append(prefix);
                    sb.append('.');
                }
                sb.append(entry.getKey());
                sb.append(';');
                continue;
            }
            if (!entry.getValue().canContainFields()) continue;
            this.traverseContainer(input, entry.getValue().containerMapping, sb, (prefix.length() > 0 ? prefix + "." : "") + entry.getKey());
        }
    }

    @Override
    public boolean equals(Object value) {
        if (!(value instanceof TaggedValue) || !super.equals(value)) {
            return false;
        }
        TaggedValue other = (TaggedValue)value;
        if (other.tag != this.tag) {
            return false;
        }
        if (this.isInput()) {
            return this.input == other.input && this.flatFieldExpr.equals(other.flatFieldExpr) && this.grouped == other.grouped && this.callByValue == other.callByValue;
        }
        if (this.canContainFields()) {
            if (this.containerMapping == null && other.containerMapping != null || this.containerMapping != null && other.containerMapping == null) {
                return false;
            }
            if (this.containerMapping == null) {
                return true;
            }
            return this.containerMapping.equals(other.containerMapping);
        }
        return this.tag == other.tag;
    }

    @Override
    public String toString() {
        if (this.isInput()) {
            return "TaggedValue(" + (Object)((Object)this.tag) + ":" + this.flatFieldExpr + ")";
        }
        if (this.canContainFields()) {
            return "TaggedValue(" + (Object)((Object)this.tag) + ":" + this.containerMapping + ")";
        }
        if (this.isIntConstant()) {
            return "TaggedValue(" + (Object)((Object)this.tag) + ":" + this.intConstant + ")";
        }
        return "TaggedValue(" + (Object)((Object)this.tag) + ")";
    }

    public Input getInput() {
        return this.input;
    }

    public String getFlatFieldExpr() {
        return this.flatFieldExpr;
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public Map<String, TaggedValue> getContainerMapping() {
        return this.containerMapping;
    }

    public boolean containerContains(String field) {
        if (this.containerMapping == null) {
            return false;
        }
        return this.containerMapping.containsKey(field);
    }

    public boolean containerHasReferences() {
        if (this.containerMapping == null) {
            return false;
        }
        for (TaggedValue value : this.containerMapping.values()) {
            if (value != null && value.isCallByValue()) continue;
            return true;
        }
        return false;
    }

    public void addContainerMapping(String field, TaggedValue mapping, ModifiedASMFrame frame) {
        if (this.containerMapping == null) {
            this.containerMapping = new HashMap<String, TaggedValue>(4);
        }
        if (this.containerFrameMapping == null) {
            this.containerFrameMapping = new HashMap<String, ModifiedASMFrame>(4);
        }
        if (this.containerMapping.containsKey(field) && this.containerMapping.get(field) != null && frame == this.containerFrameMapping.get(field)) {
            this.containerMapping.put(field, null);
            this.containerFrameMapping.remove(field);
        } else {
            this.containerMapping.put(field, mapping);
            this.containerFrameMapping.put(field, frame);
        }
    }

    public void clearContainerMappingMarkedFields() {
        if (this.containerMapping != null) {
            Iterator<Map.Entry<String, TaggedValue>> it = this.containerMapping.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, TaggedValue> entry = it.next();
                if (entry.getValue() != null) continue;
                it.remove();
            }
        }
    }

    public void makeRegular() {
        if (this.canContainFields() && this.containerMapping != null) {
            for (TaggedValue value : this.containerMapping.values()) {
                value.makeRegular();
            }
        }
        this.setTag(Tag.REGULAR);
    }

    public int getIntConstant() {
        return this.intConstant;
    }

    public TaggedValue copy() {
        return this.copy(this.getType());
    }

    public TaggedValue copy(Type type) {
        TaggedValue newValue = new TaggedValue(type);
        newValue.tag = this.tag;
        if (this.isInput()) {
            newValue.input = this.input;
            newValue.flatFieldExpr = this.flatFieldExpr;
            newValue.grouped = this.grouped;
            newValue.callByValue = this.callByValue;
        } else if (this.canContainFields()) {
            HashMap<String, TaggedValue> containerMapping = new HashMap<String, TaggedValue>(this.containerMapping.size());
            HashMap<String, ModifiedASMFrame> containerFrameMapping = this.containerFrameMapping != null ? new HashMap<String, ModifiedASMFrame>(this.containerFrameMapping.size()) : null;
            for (Map.Entry<String, TaggedValue> entry : this.containerMapping.entrySet()) {
                if (entry.getValue() != null) {
                    containerMapping.put(entry.getKey(), entry.getValue().copy());
                    if (containerFrameMapping == null) continue;
                    containerFrameMapping.put(entry.getKey(), this.containerFrameMapping.get(entry.getKey()));
                    continue;
                }
                containerMapping.put(entry.getKey(), null);
            }
            newValue.containerMapping = containerMapping;
            newValue.containerFrameMapping = containerFrameMapping;
        } else if (this.isIntConstant()) {
            newValue.intConstant = this.intConstant;
        }
        return newValue;
    }

    public static enum Input {
        INPUT_1(0),
        INPUT_2(1);

        private int id;

        private Input(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    public static enum Tag {
        REGULAR,
        THIS,
        INPUT,
        COLLECTOR,
        CONTAINER,
        INT_CONSTANT,
        INPUT_1_ITERABLE,
        INPUT_2_ITERABLE,
        INPUT_1_ITERATOR,
        INPUT_2_ITERATOR,
        ITERATOR_TRUE_ASSUMPTION,
        NULL;

    }
}

